/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.options.EnumAge;
import com.github.ipixeli.gender.core.options.EnumGender;
import com.github.ipixeli.gender.core.options.EnumModel;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import com.github.ipixeli.gender.forge.GenderForge;
import com.github.ipixeli.gender.forge.server.GenderServer;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public final class Datagram {
    private PlayerProfile profile;

    public Datagram(PlayerProfile p) {
        this.profile = p;
    }

    public static Datagram fromBytes(ByteBuf buf) {
        try {
            byte bage = buf.readByte();
            byte bgender = buf.readByte();
            byte bmodel = buf.readByte();
            String u = buf.readCharSequence(buf.capacity() - buf.readerIndex(), Charset.forName("utf-8")).toString().trim();
            String[] s = u.split("@");
            String username = s[0];
            String uuid = s[1];
            EnumAge age = EnumAge.UNSET.getFromValue(bage);
            EnumGender gender = EnumGender.UNSET.getFromValue(bgender);
            EnumModel model = EnumModel.UNSET.getFromValue(bmodel);
            if (Datagram.notEmpty(username) || Datagram.notEmpty(uuid)) {
                PlayerProfile data = new PlayerProfile("" + username, "" + uuid);
                data.setAge(age);
                data.setGender(gender);
                data.setModel(model);
                GenderForge.logger.logDebug("Successfully loaded profile from datagram: " + username + " (" + uuid + "): " + age.toString() + "; " + gender.toString() + "; " + model.toString());
                return new Datagram(data);
            }
            GenderForge.logger.logWarn("Invalid packet read.");
        }
        catch (Exception e) {
            GenderForge.logger.logWarn("Invalid packet read. Error: " + e.getMessage());
        }
        return null;
    }

    public void toBytes(ByteBuf buf) {
        try {
            String username = this.profile.name();
            String uuid = this.profile.uuid();
            EnumAge age = this.profile.getAge();
            EnumGender gender = this.profile.getGender();
            EnumModel model = this.profile.getModel();
            buf.writeByte(age.ordinal());
            buf.writeByte(gender.ordinal());
            buf.writeByte(model.ordinal());
            buf.writeCharSequence((CharSequence)new StringBuffer(username + "@" + uuid), Charset.forName("utf-8"));
            GenderForge.logger.logDebug("Successfully converted profile to bytes: " + username + " (" + uuid + "): " + age.toString() + "; " + gender.toString() + "; " + model.toString());
        }
        catch (Exception e) {
            GenderForge.logger.logWarn("Failed to convert profile to bytes. Error: " + e.getMessage());
        }
    }

    public static void onMessage(Datagram data, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            NetworkDirection direction = ((NetworkEvent.Context)context.get()).getDirection();
            if (direction.equals((Object)NetworkDirection.PLAY_TO_CLIENT)) {
                PlayerProfile p = Gender.client().tempMgr.getOrCreate(data.profile, true);
                GenderForge.logger.logDebug("Client recieved profile from server: " + p.name() + "(" + p.uuid() + "): " + p.getAge() + "; " + p.getGender() + "; " + p.getModel());
                GenderForge.logger.logDebug("TEMP now has " + Gender.client().tempMgr.getList().size() + " profiles");
            } else if (direction.equals((Object)NetworkDirection.PLAY_TO_SERVER) && ((NetworkEvent.Context)context.get()).getSender() != null) {
                ServerPlayerEntity sender = ((NetworkEvent.Context)context.get()).getSender();
                String senderUUID = sender.func_189512_bd().toString();
                String senderUsername = sender.func_200200_C_().func_150261_e();
                if (data.profile.name().equals(senderUsername) || data.profile.uuid().toString().equalsIgnoreCase(senderUUID)) {
                    PlayerProfile p = Gender.server().getListManager().getOrCreate(data.profile, true);
                    GenderForge.logger.logDebug("Server recieved profile from player: " + sender.func_200200_C_().func_150261_e() + "(" + p.uuid() + "): " + p.getAge() + "; " + p.getGender() + "; " + p.getModel());
                    GenderServer.sendToAllClients(p);
                } else {
                    GenderForge.logger.logWarn("Player " + sender.func_200200_C_().func_150261_e() + " sent another player's profile to the server. VERY SUSPICIOUS! Ignoring datagram!");
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    private static boolean notEmpty(String s) {
        return s != null && s.length() > 0;
    }
}

