/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.Mod;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import com.github.ipixeli.gender.forge.Datagram;
import com.github.ipixeli.gender.forge.Logger;
import com.github.ipixeli.gender.forge.client.GenderClient;
import com.github.ipixeli.gender.forge.server.GenderServer;
import java.io.File;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.versions.forge.ForgeVersion;

@net.minecraftforge.fml.common.Mod(value="gender")
public final class GenderForge
implements Mod {
    public static final String MC = "1.16.5";
    public static final String VER = "1.8.0";
    public static final String VERSION = "1.8.0+F2(1.16.5)";
    public static final Logger logger = new Logger();
    private static final String PROTOCOL_VERSION = "1";
    private static final Predicate<String> versions = v -> PROTOCOL_VERSION.equals(v) || NetworkRegistry.ABSENT.equals(v) || NetworkRegistry.ACCEPTVANILLA.equals(v);
    public static final SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("gender:gender")).clientAcceptedVersions(versions).serverAcceptedVersions(versions).networkProtocolVersion(() -> "1").simpleChannel();
    private static GenderForge instance;

    public GenderForge() {
        instance = this;
        new Gender(this, logger);
        logger.logInfo("Gender is version 1.8.0+F2(1.16.5) Environment Version is FORGE " + ForgeVersion.getVersion());
        channel.messageBuilder(Datagram.class, 1).decoder(Datagram::fromBytes).encoder(Datagram::toBytes).consumer(Datagram::onMessage).add();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::serverSetup);
    }

    public static GenderForge get() {
        return instance;
    }

    private static File checkSetupDirsAndConfig(File cwd) {
        File modDir = new File(cwd + "/config/gender/");
        if (!modDir.exists()) {
            logger.logWarn("Unable to locate missing folder(s): " + modDir.getAbsolutePath());
            if (modDir.mkdirs()) {
                logger.logWarn("Successfully created missing folder(s): " + modDir.getAbsolutePath());
            }
        }
        return modDir;
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent e) {
        File mcDir = ((Minecraft)e.getMinecraftSupplier().get()).field_71412_D;
        File modDir = GenderForge.checkSetupDirsAndConfig(mcDir);
        GenderClient.onStartup(modDir, (Minecraft)e.getMinecraftSupplier().get());
    }

    @SubscribeEvent
    public void serverSetup(FMLServerStartingEvent e) {
        File mcDir = e.getServer().func_71238_n();
        File modDir = GenderForge.checkSetupDirsAndConfig(mcDir);
        GenderServer.onSetup(modDir, e.getServer());
    }

    @Override
    public void sendProfilePacket(PlayerProfile p) {
        channel.sendToServer((Object)new Datagram(p));
    }

    @Override
    public Logger logger() {
        return logger;
    }
}

