/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge.client;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.client.Logic;
import com.github.ipixeli.gender.core.client.cfg.Config;
import com.github.ipixeli.gender.core.client.events.PlayerHurt;
import com.github.ipixeli.gender.forge.client.GenderClient;
import com.github.ipixeli.gender.forge.client.MCAccessor;
import com.github.ipixeli.gender.forge.client.gui.ConfigScreen;
import com.github.ipixeli.gender.forge.client.gui.ProfileScreen;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.gui.screen.ModListScreen;
import net.minecraftforge.fml.client.gui.widget.ModListWidget;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gender", value={Dist.CLIENT})
public final class ClientEvents {
    private static boolean needSendPacket = false;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onEvent(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x() == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (needSendPacket && mc.field_71441_e != null && mc.field_71439_g != null && mc.func_147114_u() != null) {
            Gender.client().onLogin();
            needSendPacket = false;
        }
        if (GenderClient.key.func_151468_f() && mc.field_71462_r == null) {
            mc.func_147108_a((Screen)new ProfileScreen());
        }
    }

    @SubscribeEvent
    public static void onEvent(WorldEvent.Load e) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.func_147114_u() != null) {
            Gender.client().onLogin();
            needSendPacket = false;
        } else {
            needSendPacket = true;
        }
    }

    @SubscribeEvent
    public static void onEvent(WorldEvent.Unload e) {
        Gender.client().onLogout();
    }

    private static StringTextComponent getCustomNameLabel(PlayerEntity p, String old) {
        MCAccessor mca = MCAccessor.instance();
        String label = Logic.getLabel(mca.getUuid(p), mca.getName(p), mca.isSelf(p), mca.isGuiRender(), old);
        return new StringTextComponent(label);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEvent(PlayerEvent.NameFormat e) {
        if (e.getEntity() == null || !(e.getEntity() instanceof PlayerEntity)) {
            return;
        }
        e.setDisplayname((ITextComponent)ClientEvents.getCustomNameLabel((PlayerEntity)e.getEntity(), e.getDisplayname().getString()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEvent(RenderNameplateEvent e) {
        if (e.getEntity() == null || !(e.getEntity() instanceof PlayerEntity)) {
            return;
        }
        e.setContent((ITextComponent)ClientEvents.getCustomNameLabel((PlayerEntity)e.getEntity(), e.getContent().getString()));
    }

    @SubscribeEvent
    public static void onEvent(PlaySoundAtEntityEvent e) {
        if (!Config.playerGenders.getValue().booleanValue() || !Config.playerGenderSounds.getValue().booleanValue()) {
            return;
        }
        if (e.getEntity() == null || e.getSound() == null || e.getSound().func_187503_a() == null || !(e.getEntity() instanceof AbstractClientPlayerEntity)) {
            return;
        }
        if (e.getSound().func_187503_a().toString().contains("entity.player.hurt")) {
            AbstractClientPlayerEntity p = (AbstractClientPlayerEntity)e.getEntity();
            BlockPos pos = p.func_233580_cy_();
            MCAccessor mca = MCAccessor.instance();
            PlayerHurt.event(mca, mca.getUuid(p), mca.getName(p), mca.isSelf(p), pos.func_177958_n(), (float)pos.func_177956_o() - 0.1f, pos.func_177952_p());
            e.setCanceled(true);
        }
    }

    private static ModListWidget.ModEntry isIfModDisplayed(ModListScreen screen) {
        try {
            Field selected = screen.getClass().getDeclaredField("selected");
            selected.setAccessible(true);
            return (ModListWidget.ModEntry)selected.get(screen);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Button getButton(ModListScreen screen) {
        try {
            Field f = screen.getClass().getDeclaredField("configButton");
            f.setAccessible(true);
            return (Button)f.get(screen);
        }
        catch (Exception e) {
            return null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEvent(GuiScreenEvent.DrawScreenEvent.Post e) {
        ModListScreen screen;
        ModListWidget.ModEntry entry;
        if (e.getGui() instanceof ModListScreen && (entry = ClientEvents.isIfModDisplayed(screen = (ModListScreen)e.getGui())) != null && entry.getInfo().getModId().equals("gender")) {
            Button button = ClientEvents.getButton(screen);
            button.field_230693_o_ = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEvent(GuiScreenEvent.MouseClickedEvent.Pre e) {
        Button button;
        ModListScreen screen;
        ModListWidget.ModEntry entry;
        if (e.getGui() instanceof ModListScreen && (entry = ClientEvents.isIfModDisplayed(screen = (ModListScreen)e.getGui())) != null && entry.getInfo().getModId().equals("gender") && (button = ClientEvents.getButton(screen)).func_231047_b_(e.getMouseX(), e.getMouseY())) {
            MCAccessor.instance().displayScreen((Object)new ConfigScreen(true));
            e.setCanceled(true);
        }
    }
}

