var ASMAPI=Java.type("net.minecraftforge.coremod.api.ASMAPI");
var Opcodes=Java.type('org.objectweb.asm.Opcodes');
var InsnList=Java.type('org.objectweb.asm.tree.InsnList');
var InsnNode=Java.type('org.objectweb.asm.tree.InsnNode');
var FieldNode=Java.type('org.objectweb.asm.tree.FieldNode');
var TypeInsnNode=Java.type('org.objectweb.asm.tree.TypeInsnNode');
var VarInsnNode=Java.type('org.objectweb.asm.tree.VarInsnNode');
var FieldInsnNode=Java.type('org.objectweb.asm.tree.FieldInsnNode');
var MethodInsnNode=Java.type('org.objectweb.asm.tree.MethodInsnNode');
var PM="net/minecraft/client/renderer/entity/model/PlayerModel";
var MR="net/minecraft/client/renderer/model/ModelRenderer";
var ACP="net/minecraft/client/entity/player/AbstractClientPlayerEntity";
var LE="net/minecraft/entity/LivingEntity";
var BBF=ASMAPI.mapField("field_78115_e");
var M0=ASMAPI.mapMethod("func_177137_d");
var M0_DESC="(L"+ACP+";)V";
var M1=ASMAPI.mapMethod("func_225620_a_");
var M1_DESC="(L"+LE+";Lcom/mojang/blaze3d/matrix/MatrixStack;F)V";
var NUM_FOUND=0;
var NUM_PATCHED=0;
function log(message){
	print("[GenderCore]: "+message);
}
function initializeCoreMod(){
	return{
		"GenderCore-PlayerRenderer":{
			"target":{"type":"CLASS",'name':'net.minecraft.client.renderer.entity.PlayerRenderer'},
			"transformer": function(classNode){
				for each(var method in classNode.methods){
					if(method.name.equals(M0)&&method.desc.equals(M0_DESC)){
						log("Transforming "+classNode.name+"."+method.name);
						patchSetVis(method);
					}else if(method.name.equals(M1)&&method.desc.equals(M1_DESC)){
						log("Transforming "+method.name+" in "+classNode.name);
						patchCallback(method);
					}
				}
				log("Found methods: "+NUM_FOUND+" of 2");
				log("Patched methods: "+NUM_PATCHED+" of 2");
				return classNode;
			}
		}
	};
}
function patchSetVis(method){
	NUM_FOUND++
	var finalReturn;
	for(var i=method.instructions.size()-1;i>=0;i--){
		var instruction=method.instructions.get(i);
		if(instruction.getOpcode()==Opcodes.RETURN){
			finalReturn=instruction;
			break;
		}
	}
	if(finalReturn==null){
		log("Failed to find last return within "+method.name+method.desc);
	}else{
		var toInject=new InsnList();
		toInject.add(new VarInsnNode(Opcodes.ALOAD,1));
		toInject.add(new VarInsnNode(Opcodes.ALOAD,2));
		toInject.add(new FieldInsnNode(Opcodes.GETFIELD,PM,BBF,"L"+MR+";"));
		toInject.add(new VarInsnNode(Opcodes.ALOAD,2));
		toInject.add(new FieldInsnNode(Opcodes.GETFIELD,PM,"cynthia","L"+MR+";"));
		toInject.add(new VarInsnNode(Opcodes.ALOAD,2));
		toInject.add(new FieldInsnNode(Opcodes.GETFIELD,PM,"stephanie","L"+MR+";"));
		toInject.add(new MethodInsnNode(Opcodes.INVOKESTATIC,"com/github/ipixeli/gender/forge/client/Renders","onEvent","(L"+ACP+";L"+MR+";L"+MR+";L"+MR+";)V"));
		method.instructions.insertBefore(finalReturn,toInject);
		NUM_PATCHED++;
	}
}
function patchCallback(method){
	NUM_FOUND++;
	var toInject=new InsnList();
	toInject.add(new VarInsnNode(Opcodes.ALOAD,1));
	toInject.add(new VarInsnNode(Opcodes.ALOAD,2));
	toInject.add(new MethodInsnNode(Opcodes.INVOKESTATIC,"com/github/ipixeli/gender/forge/client/Renders","onEvent","(L"+LE+";Lcom/mojang/blaze3d/matrix/MatrixStack;)V"));
	toInject.add(new InsnNode(Opcodes.RETURN));
	method.instructions=toInject;
	NUM_PATCHED++;
}