/*
 * Decompiled with CFR 0.152.
 */
package net.iPixeli.Gender.common;

import java.util.ArrayList;
import net.iPixeli.Gender.Gender;

public class PlayerSettingsManager {
    protected static PlayerSettingsManager instance;
    private static ArrayList<PlayerSettingKeeper> keepers;
    public static final byte CLIENT = 0;
    public static final byte TEMP = 1;
    public static final byte SERVER = 2;
    public static final byte HC = -1;

    public PlayerSettingsManager() {
        instance = this;
    }

    public static PlayerSettingsManager getInstance() {
        return instance;
    }

    public static ArrayList<PlayerSettingKeeper> getKeepers() {
        return keepers;
    }

    public static PlayerSettingKeeper get(String string) {
        for (int i = 0; i < keepers.size(); ++i) {
            PlayerSettingKeeper k = keepers.get(i);
            if (!k.getUsername().equalsIgnoreCase(string)) continue;
            return k;
        }
        return null;
    }

    public PlayerSettingKeeper newKeeper(String username) {
        PlayerSettingKeeper g = PlayerSettingsManager.get(username);
        if (g == null) {
            PlayerSettingKeeper k = new PlayerSettingKeeper(username);
            keepers.add(k);
            return k;
        }
        return g;
    }

    public PlayerSettingKeeper getOrCreate(String name) {
        PlayerSettingKeeper k = PlayerSettingsManager.get(name);
        if (k == null) {
            k = this.newKeeper(name);
        }
        return k;
    }

    public PlayerSettingKeeper getOrCreateForClientWithDefaultSettings(String username) {
        PlayerSettingKeeper k = this.getOrCreate(username);
        byte by = (byte)(Gender.instance.getConfig().defaultSettingPlayerGenderFemale ? 1 : 0);
        byte by2 = (byte)(Gender.instance.getConfig().defaultSettingPlayerAgeChild ? 1 : 0);
        Gender.instance.getConfig();
        k.setOrCreateForSideWithSettings((byte)0, by, by2, (byte)2);
        return k;
    }

    static {
        keepers = new ArrayList();
    }

    public class PlayerSettingKeeper {
        private String username;
        private PSObj psHC;
        private PSObj psServer;
        private PSObj psClient;
        private PSObj psTemp;

        private PlayerSettingKeeper(String username) {
            this.username = username;
        }

        public void setOrCreateForSideWithSettings(byte side, byte f, byte c, byte m) {
            System.out.println("[Gender] Creating for side with settings: " + side + " " + c + " " + m);
            if (side == 0) {
                if (this.psClient == null) {
                    this.psClient = new PSObj(f, c, m);
                } else {
                    this.psClient.isF = f;
                    this.psClient.isC = c;
                    this.psClient.model = m;
                }
            } else if (side == 1) {
                if (this.psTemp == null) {
                    this.psTemp = new PSObj(f, c, m);
                } else {
                    this.psTemp.isF = f;
                    this.psTemp.isC = c;
                    this.psTemp.model = m;
                }
            } else if (side == 2) {
                if (this.psServer == null) {
                    this.psServer = new PSObj(f, c, m);
                } else {
                    this.psServer.isF = f;
                    this.psServer.isC = c;
                    this.psServer.model = m;
                }
            } else if (side == -1) {
                if (this.psHC == null) {
                    this.psHC = new PSObj(f, c, m);
                    if (this.psClient == null) {
                        this.psClient = new PSObj();
                    }
                } else {
                    this.psHC.isF = f;
                    this.psHC.isC = c;
                    this.psHC.model = m;
                }
            }
        }

        public void resetForSide(byte side) {
            if (side == 0) {
                this.psClient = null;
            }
            if (side == 1) {
                this.psTemp = null;
            }
            if (side == 2) {
                this.psServer = null;
            }
            if (this.psHC == null) {
                keepers.remove(this);
            }
        }

        public String getUsername() {
            return this.username;
        }

        public PSObj getServer() {
            return this.psServer;
        }

        public PSObj getClient() {
            return this.psClient;
        }

        public PSObj getTemp() {
            return this.psTemp;
        }

        public PSObj getHC() {
            return this.psHC;
        }

        public class PSObj {
            private byte isF = (byte)-1;
            private byte isC = (byte)-1;
            private byte model = (byte)-1;

            private PSObj() {
                if (Gender.instance.getConfig().defaultSettingPlayerGenderFemale) {
                    this.isF = 1;
                }
                if (Gender.instance.getConfig().defaultSettingPlayerAgeChild) {
                    this.isC = 1;
                }
                Gender.instance.getConfig();
                this.model = (byte)2;
            }

            public PSObj(byte isF, byte isC, byte model) {
                this.isF = isF;
                this.isC = isC;
                this.model = model;
            }

            public byte isFemale() {
                return this.isF;
            }

            public byte isChild() {
                return this.isC;
            }

            public byte getModel() {
                return this.model;
            }

            public void setF(byte f) {
                this.isF = f;
            }

            public void setC(byte c) {
                this.isC = c;
            }

            public void setM(byte m) {
                this.model = m;
            }

            public void toggleGender() {
                this.isF = this.isF > -1 ? (this.isF == 0 ? (byte)1 : 0) : (byte)1;
            }

            public void toggleAge() {
                this.isC = this.isC > -1 ? (this.isC == 0 ? (byte)1 : 0) : (byte)1;
            }

            public void incrementModel() {
                if (this.model > -1) {
                    this.model = this.model <= 2 ? (byte)0 : (byte)(this.model + 1);
                } else {
                    Gender.instance.getConfig();
                    this.model = (byte)2;
                }
            }
        }
    }
}

