/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.mixin.entity;

import dev.necauqua.mods.cm.Config;
import dev.necauqua.mods.cm.Network;
import dev.necauqua.mods.cm.api.IRenderSized;
import dev.necauqua.mods.cm.api.ISized;
import dev.necauqua.mods.cm.api.IWorldPreciseSounds;
import dev.necauqua.mods.cm.size.ChangingSizeProcess;
import dev.necauqua.mods.cm.size.DataSerializerDouble;
import dev.necauqua.mods.cm.size.EntitySizeInteractions;
import dev.necauqua.mods.cm.size.IEntityExtras;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements IRenderSized,
IEntityExtras {
    private static final DataParameter<Double> $CM$SIZE = EntityDataManager.func_187226_a(Entity.class, (DataSerializer)DataSerializerDouble.INSTANCE);
    private static final String SIZE_NBT_TAG = "chiseled_me:size";
    public double $cm$size = 1.0;
    public float $cm$originalWidth = 0.0f;
    public float $cm$originalHeight = 0.0f;
    @Nullable
    private ChangingSizeProcess $cm$process = null;
    @Shadow
    public World field_70170_p;
    @Shadow
    protected EntityDataManager field_70180_af;
    @Shadow
    public float field_70130_N;
    @Shadow
    public float field_70131_O;
    @Shadow
    public double field_70159_w;
    @Shadow
    public double field_70181_x;
    @Shadow
    public double field_70179_y;
    @Shadow
    public boolean field_70122_E;

    @Override
    public double getSizeCM() {
        return this.$cm$size;
    }

    @Override
    public double getSizeCM(float partialTick) {
        return this.$cm$process != null ? this.$cm$process.prevTickSize + (this.$cm$size - this.$cm$process.prevTickSize) * (double)partialTick : this.$cm$size;
    }

    @Override
    public void setSizeCM(double size, int lerpTime) {
        this.func_184210_p();
        this.func_184226_ay();
        EntitySizeInteractions.wakeUp((Entity)this);
        if (lerpTime == 0) {
            this.setRawSizeCM(size);
        } else {
            this.$cm$process = new ChangingSizeProcess(this.$cm$size, size, lerpTime);
            if (!this.field_70170_p.field_72995_K) {
                Network.sync((Entity)this, size, lerpTime);
            }
        }
        Entity[] parts = this.func_70021_al();
        if (parts != null) {
            for (Entity part : parts) {
                ((IRenderSized)part).setSizeCM(size, lerpTime);
            }
        }
    }

    @Override
    public boolean isResizingCM() {
        return this.$cm$process != null;
    }

    @Override
    public void setRawSizeCM(double size) {
        this.$cm$size = size;
        if (this.$cm$process == null) {
            this.field_70180_af.func_187227_b($CM$SIZE, (Object)size);
        }
        if (this.$cm$originalWidth == 0.0f) {
            this.$cm$originalWidth = this.field_70130_N;
        }
        if (this.$cm$originalHeight == 0.0f) {
            this.$cm$originalHeight = this.field_70131_O;
        }
        this.field_70130_N = (float)((double)this.$cm$originalWidth * size);
        float w = this.field_70130_N / 2.0f;
        float h = this.field_70131_O = (float)((double)this.$cm$originalHeight * size);
        AxisAlignedBB aabb = this.func_174813_aQ();
        double x = (aabb.field_72340_a + aabb.field_72336_d) / 2.0;
        double z = (aabb.field_72339_c + aabb.field_72334_f) / 2.0;
        this.func_174826_a(new AxisAlignedBB(x - (double)w, aabb.field_72338_b, z - (double)w, x + (double)w, aabb.field_72338_b + (double)h, z + (double)w));
    }

    @Override
    public void onUpdateCM() {
        ChangingSizeProcess p = this.$cm$process;
        if (p == null) {
            return;
        }
        if (p.lerpedTicks++ < p.lerpTime) {
            p.prevTickSize = this.$cm$size;
            this.setRawSizeCM(p.fromSize + (p.toSize - p.fromSize) / (double)p.lerpTime * (double)p.lerpedTicks);
        } else {
            this.$cm$process = null;
            this.setRawSizeCM(p.toSize);
        }
    }

    @Override
    public void setOriginalWidthCM(float width) {
        this.$cm$originalWidth = width;
    }

    @Override
    public void setOriginalHeightCM(float height) {
        this.$cm$originalHeight = height;
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/network/datasync/EntityDataManager;register(Lnet/minecraft/network/datasync/DataParameter;Ljava/lang/Object;)V"))
    void registerSize(EntityDataManager dataManager, DataParameter key, Object value, World world) {
        dataManager.func_187214_a($CM$SIZE, (Object)this.$cm$size);
        dataManager.func_187214_a(key, value);
    }

    @Inject(method={"notifyDataManagerChange"}, at={@At(value="HEAD")})
    void notifyDataManagerChange(DataParameter<?> key, CallbackInfo ci) {
        if ($CM$SIZE.equals(key)) {
            this.setSizeCM((Double)this.field_70180_af.func_187225_a($CM$SIZE), 0);
        }
    }

    @ModifyVariable(method={"setSize"}, at=@At(value="HEAD"), ordinal=0)
    float setSizeWidth(float width) {
        this.$cm$originalWidth = width;
        return (float)((double)width * this.$cm$size);
    }

    @ModifyVariable(method={"setSize"}, at=@At(value="HEAD"), ordinal=1)
    float setSizeHeight(float height) {
        this.$cm$originalHeight = height;
        return (float)((double)height * this.$cm$size);
    }

    @ModifyConstant(method={"isEntityInsideOpaqueBlock"}, constant={@Constant(floatValue=0.1f)})
    float isEntityInsideOpaqueBlock(float constant) {
        return (float)((double)constant * this.$cm$size);
    }

    @ModifyConstant(method={"doBlockCollisions"}, constant={@Constant(doubleValue=0.001)})
    double doBlockCollisions(double constant) {
        return constant * this.$cm$size;
    }

    @ModifyConstant(method={"isInLava"}, constant={@Constant(doubleValue=-0.10000000149011612), @Constant(doubleValue=-0.4000000059604645)})
    double isInLava(double constant) {
        return constant * this.$cm$size;
    }

    @ModifyConstant(method={"isOverWater"}, constant={@Constant(doubleValue=-20.0), @Constant(doubleValue=0.001)})
    double isOverWater(double constant) {
        return constant * this.$cm$size;
    }

    @ModifyVariable(method={"move"}, at=@At(value="HEAD"), ordinal=0)
    double moveX(double x, MoverType type) {
        return type == MoverType.SELF || type == MoverType.PLAYER ? x * this.$cm$size : x;
    }

    @ModifyVariable(method={"move"}, at=@At(value="HEAD"), ordinal=1)
    double moveY(double y, MoverType type) {
        return type == MoverType.SELF || type == MoverType.PLAYER ? y * this.$cm$size : y;
    }

    @ModifyVariable(method={"move"}, at=@At(value="HEAD"), ordinal=2)
    double moveZ(double z, MoverType type) {
        return type == MoverType.SELF || type == MoverType.PLAYER ? z * this.$cm$size : z;
    }

    @ModifyConstant(method={"move"}, constant={@Constant(doubleValue=0.5), @Constant(doubleValue=-0.5), @Constant(doubleValue=0.20000000298023224), @Constant(doubleValue=0.001)})
    double moveConstantsMul(double constant) {
        return constant * this.$cm$size;
    }

    @ModifyConstant(method={"move"}, constant={@Constant(doubleValue=0.6)})
    double moveStepSound(double constant) {
        return constant / this.$cm$size;
    }

    @ModifyConstant(method={"move"}, constant={@Constant(floatValue=0.35f)})
    float moveSwimSound(float constant) {
        return (float)((double)constant / this.$cm$size);
    }

    @Redirect(method={"move"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;stepHeight:F"))
    float moveStepHeight(Entity self) {
        return (float)((double)self.field_70138_W * this.$cm$size);
    }

    @ModifyConstant(method={"handleWaterMovement"}, constant={@Constant(doubleValue=-0.4000000059604645), @Constant(doubleValue=0.001)})
    double handleWaterMovement(double constant) {
        return constant * this.$cm$size;
    }

    @ModifyVariable(method={"updateFallState"}, at=@At(value="HEAD"), ordinal=0)
    double updateFallState(double y) {
        return !Config.scaleFallSmall && this.$cm$size < 1.0 || !Config.scaleFallBig && this.$cm$size > 1.0 ? y : y / this.$cm$size;
    }

    @Redirect(method={"applyEntityCollision"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/entity/Entity;addVelocity(DDD)V"))
    void applyEntityCollision(Entity self, double x, double y, double z, Entity other) {
        if (this.$cm$size < 1.0 && Config.scaleMassSmall || this.$cm$size > 1.0 && Config.scaleMassBig) {
            double coeff = ((ISized)other).getSizeCM() / this.$cm$size;
            self.func_70024_g(x * coeff, y * coeff, z * coeff);
        } else {
            self.func_70024_g(x, y, z);
        }
    }

    @Redirect(method={"applyEntityCollision"}, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/entity/Entity;addVelocity(DDD)V"))
    void applyEntityCollision2(Entity self, double x, double y, double z, Entity other) {
        double otherSize = ((ISized)other).getSizeCM();
        if (otherSize < 1.0 && Config.scaleMassSmall || otherSize > 1.0 && Config.scaleMassBig) {
            double coeff = this.$cm$size / otherSize;
            self.func_70024_g(x * coeff, y * coeff, z * coeff);
        } else {
            self.func_70024_g(x, y, z);
        }
    }

    @ModifyVariable(method={"entityDropItem"}, at=@At(value="LOAD"))
    float entityDropItem(float offsetY) {
        return (float)((double)offsetY * this.$cm$size);
    }

    @ModifyVariable(method={"entityDropItem"}, at=@At(value="STORE"))
    EntityItem entityDropItem(EntityItem entityItem) {
        ((IRenderSized)entityItem).setSizeCM(this.$cm$size);
        return entityItem;
    }

    @Inject(method={"readFromNBT"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;readEntityFromNBT(Lnet/minecraft/nbt/NBTTagCompound;)V")})
    void readFromNBT(NBTTagCompound nbt, CallbackInfo ci) {
        double size = nbt.func_74769_h(SIZE_NBT_TAG);
        if (size != 0.0) {
            this.setSizeCM(size);
        }
    }

    @Inject(method={"writeToNBT"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;writeEntityToNBT(Lnet/minecraft/nbt/NBTTagCompound;)V")})
    void writeToNBT(NBTTagCompound nbt, CallbackInfoReturnable<NBTTagCompound> cir) {
        nbt.func_74780_a(SIZE_NBT_TAG, this.$cm$process != null ? this.$cm$process.toSize : this.$cm$size);
    }

    @ModifyConstant(method={"toString"}, remap=false, constant={@Constant(ordinal=0)})
    String toStringArgs(String constant) {
        return constant.substring(0, constant.length() - 1) + ", cm:size=%.4f" + constant.substring(constant.length() - 1);
    }

    @ModifyArg(method={"toString"}, remap=false, at=@At(value="INVOKE", target="Ljava/lang/String;format(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;"))
    Object[] toStringArgs(Object[] args) {
        Object[] modified = Arrays.copyOf(args, args.length + 1);
        modified[args.length] = this.$cm$size;
        return modified;
    }

    @ModifyArg(method={"doWaterSplashEffect"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnParticle(Lnet/minecraft/util/EnumParticleTypes;DDDDDD[I)V"))
    int[] doWaterSplashEffect(int[] args) {
        return EntitySizeInteractions.appendSize(args, this.$cm$size);
    }

    @Inject(method={"spawnRunningParticles"}, at={@At(value="HEAD")}, cancellable=true)
    void createRunningParticles(CallbackInfo ci) {
        if (!this.field_70122_E) {
            ci.cancel();
        }
    }

    @ModifyConstant(method={"createRunningParticles"}, constant={@Constant(doubleValue=0.1), @Constant(doubleValue=0.20000000298023224)})
    double createRunningParticles(double constant) {
        return constant * this.$cm$size;
    }

    @ModifyArg(method={"createRunningParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnParticle(Lnet/minecraft/util/EnumParticleTypes;DDDDDD[I)V"))
    int[] createRunningParticles(int[] args) {
        return EntitySizeInteractions.appendSize(args, this.$cm$size);
    }

    @Inject(method={"playStepSound"}, at={@At(value="HEAD")}, cancellable=true)
    void playStepSound(CallbackInfo ci) {
        if (!this.field_70122_E) {
            ci.cancel();
        }
    }

    @Redirect(method={"playSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/EntityPlayer;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V"))
    void playSound(World self, EntityPlayer player, double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        ((IWorldPreciseSounds)self).playSound(null, new Vec3d(x, y, z), soundIn, category, volume, pitch, this.$cm$size);
    }

    @ModifyConstant(method={"getPosition"}, constant={@Constant(doubleValue=0.5)})
    double getPosition(double constant) {
        return constant * this.$cm$size;
    }

    @Shadow
    protected abstract void func_70105_a(float var1, float var2);

    @Shadow
    public abstract AxisAlignedBB func_174813_aQ();

    @Shadow
    public abstract void func_174826_a(AxisAlignedBB var1);

    @Shadow
    public abstract void func_184210_p();

    @Shadow
    public abstract void func_184226_ay();

    @Shadow
    @Nullable
    public abstract Entity[] func_70021_al();

    @Shadow
    public abstract String func_70005_c_();

    @Shadow
    public abstract Vec3d func_174824_e(float var1);
}

