/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.size;

import dev.necauqua.mods.cm.ChiseledMe;
import dev.necauqua.mods.cm.Config;
import dev.necauqua.mods.cm.Log;
import dev.necauqua.mods.cm.SidedHandler;
import dev.necauqua.mods.cm.api.IRenderSized;
import dev.necauqua.mods.cm.api.ISized;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import net.minecraft.block.BlockBed;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="chiseled_me")
public final class EntitySizeInteractions {
    private static final String NBT_KEY_SIZE = "chiseled_me:size";
    private static final EntityPlayer.SleepResult TOO_SMALL = EnumHelper.addStatus((String)"TOO_SMALL");
    private static final EntityPlayer.SleepResult TOO_BIG = EnumHelper.addStatus((String)"TOO_BIG");

    private EntitySizeInteractions() {
    }

    @ChiseledMe.Init
    private static void init() {
        if (Config.changeBedAABB) {
            EntitySizeInteractions.fixBedAABB();
        }
        GameRegistry.registerEntitySelector((arguments, mainSelector, sender, position) -> {
            double min = MathHelper.func_82712_a((String)arguments.getOrDefault("minsize", ""), (double)0.0);
            double max = MathHelper.func_82712_a((String)arguments.getOrDefault("size", ""), (double)Double.MAX_VALUE);
            return Collections.singletonList(entity -> {
                double size = ((ISized)entity).getSizeCM();
                return min <= size && size <= max;
            });
        }, (String[])new String[]{"size", "minsize"});
    }

    private static void fixBedAABB() {
        try {
            EnumHelper.setFailsafeFieldValue((Field)ObfuscationReflectionHelper.findField(BlockBed.class, (String)"field_185513_c"), null, (Object)new AxisAlignedBB(0.0, 0.1875, 0.0, 1.0, 0.5625, 1.0));
        }
        catch (Exception e) {
            Log.error("Failed to modify bed AABB!", e);
        }
    }

    @SubscribeEvent
    public static void on(PlayerInteractEvent.EntityInteractSpecific e) {
        if (((ISized)e.getEntity()).getSizeCM() != ((ISized)e.getTarget()).getSizeCM()) {
            e.setCanceled(true);
        }
        for (EnumHand hand : EnumHand.values()) {
            if (e.getEntityPlayer().func_184586_b(hand).func_77973_b() != ChiseledMe.RECALIBRATOR) continue;
            e.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public static void on(PlayerInteractEvent.EntityInteract e) {
        for (EnumHand hand : EnumHand.values()) {
            if (e.getEntityPlayer().func_184586_b(hand).func_77973_b() != ChiseledMe.RECALIBRATOR) continue;
            e.setCanceled(true);
            break;
        }
    }

    @SubscribeEvent
    public static void on(EntityMountEvent e) {
        double mountedSize;
        if (Config.allowAnyRiding || !e.isMounting()) {
            return;
        }
        double mountingSize = ((ISized)e.getEntityMounting()).getSizeCM();
        double d = mountedSize = e.getEntityBeingMounted() != null ? ((ISized)e.getEntityBeingMounted()).getSizeCM() : 1.0;
        if (!(Config.allowRidingSameSize && mountingSize == mountedSize || mountingSize == 1.0 && mountedSize == 1.0)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void on(PlayerSleepInBedEvent e) {
        EntityPlayer player = e.getEntityPlayer();
        double size = ((ISized)player).getSizeCM();
        if (size < 1.0 && !Config.allowSleepingWhenSmall) {
            e.setResult(TOO_SMALL);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chiseled_me.bed.too_small", new Object[0]));
        } else if (size > 1.0 && !Config.allowSleepingWhenBig) {
            e.setResult(TOO_BIG);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chiseled_me.bed.too_big", new Object[0]));
        }
    }

    @SubscribeEvent
    public static void on(LivingDropsEvent e) {
        double size = ((ISized)e.getEntity()).getSizeCM();
        if (size == 1.0) {
            return;
        }
        for (EntityItem item : e.getDrops()) {
            ((ISized)item).setSizeCM(size);
        }
    }

    @SubscribeEvent
    public static void on(ItemTossEvent e) {
        double size = ((ISized)e.getPlayer()).getSizeCM();
        if (size != 1.0) {
            ((ISized)e.getEntity()).setSizeCM(size);
        }
    }

    private static void applyDefaultSize(Entity entity, String entitySizeRule) {
        try {
            double size = MathHelper.func_151237_a((double)Double.parseDouble(entity.field_70170_p.func_82736_K().func_82767_a(entitySizeRule)), (double)2.44140625E-4, (double)16.0);
            if (size != 1.0 && ((ISized)entity).getSizeCM() == 1.0) {
                ((ISized)entity).setSizeCM(size);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void on(PlayerEvent.Clone e) {
        if (e.isWasDeath() && e.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("chiseled_me:keepSize")) {
            ((ISized)e.getEntityPlayer()).setSizeCM(((ISized)e.getOriginal()).getSizeCM());
        }
    }

    @SubscribeEvent
    public static void on(EntityJoinWorldEvent e) {
        EntityLivingBase thrower;
        Entity entity = e.getEntity();
        if (entity instanceof EntityPlayer) {
            EntitySizeInteractions.applyDefaultSize(entity, "chiseled_me:defaultPlayerSize");
        } else {
            EntitySizeInteractions.applyDefaultSize(entity, "chiseled_me:defaultEntitySize");
        }
        if (entity instanceof EntityItem) {
            ItemStack stack = ((EntityItem)entity).func_92059_d();
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null && nbt.func_150297_b(NBT_KEY_SIZE, 6)) {
                ((ISized)entity).setSizeCM(nbt.func_74769_h(NBT_KEY_SIZE));
                nbt.func_82580_o(NBT_KEY_SIZE);
                if (nbt.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
            return;
        }
        if (entity instanceof EntityThrowable) {
            thrower = ((EntityThrowable)entity).func_85052_h();
        } else if (entity instanceof EntityArrow) {
            thrower = ((EntityArrow)entity).field_70250_c;
        } else if (entity instanceof EntityFireball) {
            thrower = ((EntityFireball)entity).field_70235_a;
        } else if (entity instanceof IThrowableEntity) {
            thrower = ((IThrowableEntity)entity).getThrower();
        } else {
            return;
        }
        if (thrower == null) {
            return;
        }
        double size = ((ISized)thrower).getSizeCM();
        if (size != 1.0) {
            ((ISized)entity).setSizeCM(size);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void on(PlayerEvent.BreakSpeed e) {
        e.setNewSpeed((float)((double)e.getNewSpeed() * ((ISized)e.getEntity()).getSizeCM()));
    }

    @SubscribeEvent
    public static void on(RenderGameOverlayEvent.Text e) {
        EntityPlayer player = SidedHandler.instance.getClientPlayer();
        if (player == null) {
            return;
        }
        double size = ((ISized)player).getSizeCM();
        if (size == 1.0) {
            return;
        }
        ArrayList list = e.getLeft();
        if (list.size() >= 3) {
            list.add(list.size() - 3, String.format("Size: %f", size));
        }
    }

    @SubscribeEvent
    public static void on(BabyEntitySpawnEvent e) {
        double size = ((ISized)e.getParentA()).getSizeCM();
        EntityAgeable child = e.getChild();
        if (child != null && size != 1.0) {
            ((ISized)child).setSizeCM(size);
        }
    }

    public static void wakeUp(Entity entity) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70608_bn()) {
            ((EntityPlayer)entity).func_70999_a(true, !entity.field_70170_p.field_72995_K, true);
        }
    }

    public static double getAverageSize(Object a, Object b) {
        double sb;
        double sa = ((ISized)a).getSizeCM();
        return sa == (sb = ((ISized)b).getSizeCM()) ? sa : Math.sqrt(sa * sb);
    }

    @SideOnly(value=Side.CLIENT)
    public static double getViewerSize() {
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        return viewer != null ? ((ISized)viewer).getSizeCM() : 1.0;
    }

    @SideOnly(value=Side.CLIENT)
    public static double getViewerSize(float partialTicks) {
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        return viewer != null ? ((IRenderSized)viewer).getSizeCM(partialTicks) : 1.0;
    }

    public static int[] appendSize(int[] array, double d) {
        if (d == 1.0) {
            return array;
        }
        int[] modified = Arrays.copyOf(array, array.length + 2);
        long bits = Double.doubleToRawLongBits(d);
        modified[array.length] = (int)(bits >> 32);
        modified[array.length + 1] = (int)bits;
        return modified;
    }

    public static double extractSize(int particleId, int[] parameters) {
        int offset;
        EnumParticleTypes type = EnumParticleTypes.func_179342_a((int)particleId);
        if (type == null) {
            return 1.0;
        }
        int count = type.func_179345_d();
        if (parameters.length - count == 2) {
            offset = count;
        } else if (type == EnumParticleTypes.ITEM_CRACK && parameters.length > 2) {
            offset = 1;
        } else {
            return 1.0;
        }
        return Double.longBitsToDouble((long)parameters[offset] << 32 | (long)parameters[offset + 1] & 0xFFFFFFFFL);
    }
}

