/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm;

import com.google.common.collect.Maps;
import dev.necauqua.mods.cm.Network;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class EntitySizeManager {
    public static final String NBT_KEY_SIZE = "chiseled_me:size";
    private static final double TWO_OVER_LOG_TWO = 2.0 / Math.log(2.0);
    public static final float LOWER_LIMIT = 2.4414062E-4f;
    public static final float UPPER_LIMIT = 16.0f;
    private static final Map<Integer, Float> spawnSetSizeQueue = Maps.newHashMap();

    private EntitySizeManager() {
    }

    public static float getSize(Entity entity) {
        return ((EntitySizeData)entity.getCapability(EntitySizeData.CAPABILITY, null)).interpSize;
    }

    public static float getRenderSize(Entity entity, float partialTick) {
        return ((EntitySizeData)entity.getCapability(EntitySizeData.CAPABILITY, null)).getRenderSize(partialTick);
    }

    public static void setSize(Entity entity, float size, boolean interp) {
        ((EntitySizeData)entity.getCapability(EntitySizeData.CAPABILITY, null)).setSize(size, interp);
    }

    public static void updateSize(Entity entity) {
        ((EntitySizeData)entity.getCapability(EntitySizeData.CAPABILITY, null)).updateSize();
    }

    @SideOnly(value=Side.CLIENT)
    public static void enqueueSetSize(int entityId, float size) {
        ClientOnly.enqueueSetSize(entityId, size);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent.Entity e) {
        e.addCapability(new ResourceLocation("chiseled_me", "size"), (ICapabilityProvider)new EntitySizeData(e.getEntity()));
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent e) {
        Entity entity = e.getEntity();
        if (entity.field_70170_p.field_72995_K) {
            Float size = spawnSetSizeQueue.remove(entity.func_145782_y());
            if (size != null) {
                EntitySizeManager.setSize(entity, size.floatValue(), false);
            }
        } else {
            float size = EntitySizeManager.getSize(entity);
            if (size != 1.0f) {
                Network.sendSetSizeToClients(entity, size, false);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone e) {
        float size;
        EntityPlayer player = e.getEntityPlayer();
        if (!e.isWasDeath() && player instanceof EntityPlayerMP && (size = EntitySizeManager.getSize((Entity)player)) != 1.0f) {
            Network.sendEnqueueSetSizeToClient((EntityPlayerMP)player, (Entity)player, size);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        float size = ((EntitySizeData)e.player.getCapability(EntitySizeData.CAPABILITY, null)).nextSize;
        if (size != 1.0f && e.player instanceof EntityPlayerMP) {
            Network.sendEnqueueSetSizeToClient((EntityPlayerMP)e.player, (Entity)e.player, size);
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking e) {
        EntityPlayer player;
        float size;
        ItemStack stack;
        NBTTagCompound nbt;
        Entity entity = e.getTarget();
        EntitySizeData data = (EntitySizeData)entity.getCapability(EntitySizeData.CAPABILITY, null);
        if (entity instanceof EntityItem && (nbt = (stack = ((EntityItem)entity).func_92059_d()).func_77978_p()) != null && nbt.func_150297_b(NBT_KEY_SIZE, 5)) {
            data.setSize(nbt.func_74760_g(NBT_KEY_SIZE), false);
            nbt.func_82580_o(NBT_KEY_SIZE);
            if (nbt.func_82582_d()) {
                stack.func_77982_d(null);
            }
        }
        if ((size = data.nextSize) != 1.0f && (player = e.getEntityPlayer()) instanceof EntityPlayerMP) {
            Network.sendEnqueueSetSizeToClient((EntityPlayerMP)player, entity, size);
        }
    }

    public static void init() {
        CapabilityManager.INSTANCE.register(EntitySizeData.class, (Capability.IStorage)new Capability.IStorage<EntitySizeData>(){

            public NBTBase writeNBT(Capability<EntitySizeData> capability, EntitySizeData instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<EntitySizeData> capability, EntitySizeData instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT(nbt);
            }
        }, EntitySizeData.class);
        MinecraftForge.EVENT_BUS.register((Object)new EntitySizeManager());
    }

    public static final class EntitySizeData
    implements ICapabilitySerializable<NBTBase> {
        @CapabilityInject(value=EntitySizeData.class)
        public static Capability<EntitySizeData> CAPABILITY = null;
        private final Entity entity;
        private final boolean isPlayer;
        private float prevSize = 1.0f;
        private float nextSize = 1.0f;
        private float prevInterpSize = 1.0f;
        private float interpSize = 1.0f;
        private float originalWidth = 1.0f;
        private float originalHeight = 1.0f;
        private boolean sizeWasSet = false;
        private int interpInterval = 0;
        private int interpTicks = 0;

        private EntitySizeData(Entity entity) {
            this.entity = entity;
            this.isPlayer = entity instanceof EntityPlayer;
        }

        public void updateSize() {
            if (this.interpInterval != 0) {
                if (this.interpTicks++ < this.interpInterval) {
                    this.prevInterpSize = this.interpSize;
                    this.interpSize = this.prevSize + (this.nextSize - this.prevSize) / (float)this.interpInterval * (float)this.interpTicks;
                    this.setBBoxSize(this.interpSize);
                    return;
                }
                this.interpTicks = 0;
                this.prevInterpSize = this.interpSize;
                this.interpSize = this.nextSize;
                this.setBBoxSize(this.nextSize);
                this.interpInterval = 0;
            } else if (this.nextSize != 1.0f && !this.isPlayer) {
                this.setBBoxSize(this.nextSize);
            }
        }

        private void setBBoxSize(float size) {
            if (!this.sizeWasSet) {
                this.originalWidth = this.entity.field_70130_N;
                this.originalHeight = this.entity.field_70131_O;
                this.sizeWasSet = true;
            }
            Vec3d pos = this.entity.func_174791_d();
            float w = this.originalWidth * size / 2.0f;
            float h = this.originalHeight * size;
            this.entity.field_70130_N = w * 2.0f;
            this.entity.field_70131_O = h;
            this.entity.func_174826_a(new AxisAlignedBB(pos.field_72450_a - (double)w, pos.field_72448_b, pos.field_72449_c - (double)w, pos.field_72450_a + (double)w, pos.field_72448_b + (double)h, pos.field_72449_c + (double)w));
        }

        private void setAllSizes(float size) {
            this.interpTicks = 0;
            this.interpInterval = 0;
            this.prevSize = size;
            this.interpSize = size;
            this.nextSize = size;
            this.prevInterpSize = size;
        }

        private void setSize(float size, boolean interp) {
            if (size < 2.4414062E-4f || size > 16.0f) {
                return;
            }
            Entity[] parts = this.entity.func_70021_al();
            if (parts != null) {
                for (Entity part : parts) {
                    ((EntitySizeData)part.getCapability(CAPABILITY, null)).setSize(size, interp);
                }
            }
            this.entity.func_184210_p();
            this.entity.func_184226_ay();
            this.prevSize = this.interpSize;
            this.nextSize = size;
            if (interp) {
                this.interpTicks = 0;
                this.interpInterval = (int)(Math.abs(Math.log(this.prevSize) - Math.log(this.nextSize)) * TWO_OVER_LOG_TWO);
                return;
            }
            this.setBBoxSize(size);
            this.setAllSizes(size);
        }

        public float getSize() {
            return this.interpSize;
        }

        public float getRenderSize(float partialTick) {
            return this.prevInterpSize + (this.interpSize - this.prevInterpSize) * partialTick;
        }

        public NBTBase serializeNBT() {
            return new NBTTagFloat(this.nextSize);
        }

        public void deserializeNBT(NBTBase nbt) {
            if (nbt instanceof NBTPrimitive) {
                this.setAllSizes(((NBTPrimitive)nbt).func_150288_h());
            }
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CAPABILITY ? CAPABILITY.cast((Object)this) : null);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class ClientOnly {
        private ClientOnly() {
        }

        static void enqueueSetSize(int entityId, float size) {
            Entity entity;
            WorldClient clientWorld = Minecraft.func_71410_x().field_71441_e;
            if (clientWorld != null && (entity = clientWorld.func_73045_a(entityId)) != null) {
                EntitySizeManager.setSize(entity, size, false);
                return;
            }
            spawnSetSizeQueue.put(entityId, Float.valueOf(size));
        }
    }
}

