/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm;

import dev.necauqua.mods.cm.Config;
import dev.necauqua.mods.cm.EntitySizeManager;
import dev.necauqua.mods.cm.Log;
import java.lang.reflect.Field;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public final class Handlers {
    private static final EntityPlayer.SleepResult TOO_SMALL = EnumHelper.addStatus((String)"TOO_SMALL");
    private static final EntityPlayer.SleepResult TOO_BIG = EnumHelper.addStatus((String)"TOO_BIG");

    private Handlers() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new Handlers());
        if (Config.changeBedAABB) {
            Handlers.fixBedAABB();
        }
    }

    private static void fixBedAABB() {
        try {
            Field f = ReflectionHelper.findField(BlockBed.class, (String[])new String[]{"field_185513_c", "BED_AABB"});
            AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.1875, 0.0, 1.0, 0.5625, 1.0);
            EnumHelper.setFailsafeFieldValue((Field)f, null, (Object)aabb);
        }
        catch (Exception e) {
            Log.error("Failed to modify bed AABB!", e);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent e) {
        float size;
        EntityLivingBase thrower;
        Entity entity = e.getEntity();
        if (entity instanceof EntityThrowable) {
            thrower = ((EntityThrowable)entity).func_85052_h();
        } else if (entity instanceof EntityArrow) {
            thrower = ((EntityArrow)entity).field_70250_c;
        } else if (entity instanceof IThrowableEntity) {
            thrower = ((IThrowableEntity)entity).getThrower();
        } else {
            return;
        }
        if (thrower != null && (size = EntitySizeManager.getSize((Entity)thrower)) != 1.0f) {
            EntitySizeManager.setSize(entity, size, false);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        float size = EntitySizeManager.getSize((Entity)entity);
        if (size == 1.0f) {
            return;
        }
        if (size < 1.0f && Config.scaleSmall) {
            event.setDamageMultiplier(event.getDamageMultiplier() * size);
            return;
        }
        if (size > 1.0f && Config.scaleBig) {
            event.setDamageMultiplier(event.getDamageMultiplier() * size);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteractSpecific e) {
        if (EntitySizeManager.getSize(e.getEntity()) != EntitySizeManager.getSize(e.getTarget())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent e) {
        if (e.isMounting() && (EntitySizeManager.getSize(e.getEntityMounting()) != 1.0f || EntitySizeManager.getSize(e.getEntityBeingMounted()) != 1.0f)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent e) {
        EntityPlayer player = e.getEntityPlayer();
        float size = EntitySizeManager.getSize((Entity)player);
        if (size < 1.0f) {
            e.setResult(TOO_SMALL);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chiseled_me.bed.too_small", new Object[0]));
        } else if (size > 1.0f) {
            e.setResult(TOO_BIG);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chiseled_me.bed.too_big", new Object[0]));
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent e) {
        float size = EntitySizeManager.getSize(e.getEntity());
        if (size != 1.0f) {
            for (EntityItem item : e.getDrops()) {
                EntitySizeManager.setSize((Entity)item, size, false);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDrop(ItemTossEvent e) {
        float size = EntitySizeManager.getSize((Entity)e.getPlayer());
        if (size != 1.0f) {
            EntitySizeManager.setSize((Entity)e.getEntityItem(), size, false);
        }
    }

    @SubscribeEvent
    public void onPlayerBreak(BlockEvent.HarvestDropsEvent e) {
        EntityPlayer player = e.getHarvester();
        if (player != null) {
            float f;
            float size = EntitySizeManager.getSize((Entity)player);
            if ((double)f < 1.0) {
                for (ItemStack stack : e.getDrops()) {
                    NBTTagCompound nbt = stack.func_77978_p();
                    if (nbt == null) {
                        nbt = new NBTTagCompound();
                    }
                    nbt.func_74776_a("chiseled_me:size", size);
                    stack.func_77982_d(nbt);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerBreakSpeed(PlayerEvent.BreakSpeed e) {
        e.setNewSpeed(e.getNewSpeed() * EntitySizeManager.getSize(e.getEntity()));
    }
}

