/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm;

import dev.necauqua.mods.cm.EntitySizeManager;
import dev.necauqua.mods.cm.Log;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class Network {
    private static FMLEventChannel chan;

    private Network() {
    }

    public static void init() {
        chan = NetworkRegistry.INSTANCE.newEventDrivenChannel("chiseled_me");
        chan.register((Object)new Network());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientReceive(FMLNetworkEvent.ClientCustomPacketEvent e) {
        ClientOnly.onClientReceive(e);
    }

    private static FMLProxyPacket packet(int id, Consumer<PacketBuffer> data) {
        PacketBuffer payload = new PacketBuffer(Unpooled.buffer());
        payload.writeByte(id);
        data.accept(payload);
        return new FMLProxyPacket(payload, "chiseled_me");
    }

    public static void sendSetSizeToClients(Entity entity, float size, boolean interp) {
        chan.sendToDimension(Network.packet(0, p -> {
            p.writeInt(entity.func_145782_y());
            p.writeFloat(size);
            p.writeBoolean(interp);
        }), entity.field_71093_bK);
    }

    public static void sendEnqueueSetSizeToClient(EntityPlayerMP client, Entity entity, float size) {
        chan.sendTo(Network.packet(1, p -> {
            p.writeInt(entity.func_145782_y());
            p.writeFloat(size);
        }), client);
    }

    @SideOnly(value=Side.CLIENT)
    private static class ClientOnly {
        private ClientOnly() {
        }

        static void onClientReceive(FMLNetworkEvent.ClientCustomPacketEvent e) {
            PacketBuffer payload = new PacketBuffer(e.getPacket().payload());
            switch (payload.readByte()) {
                case 0: {
                    WorldClient clientWorld = Minecraft.func_71410_x().field_71441_e;
                    if (clientWorld != null) {
                        int id = payload.readInt();
                        Entity entity = clientWorld.func_73045_a(id);
                        if (entity != null) {
                            EntitySizeManager.setSize(entity, payload.readFloat(), payload.readBoolean());
                            break;
                        }
                        Log.warn("Client entity with id " + id + " is null! This mean you've desynced somewhere =/");
                        break;
                    }
                    Log.warn("Somehow client world does not yet exist, this should never happen!");
                    break;
                }
                case 1: {
                    EntitySizeManager.enqueueSetSize(payload.readInt(), payload.readFloat());
                }
            }
        }
    }
}

