/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.asm;

import dev.necauqua.mods.cm.asm.dsl.ASM;
import dev.necauqua.mods.cm.asm.dsl.Hook;
import dev.necauqua.mods.cm.asm.dsl.Patch;
import dev.necauqua.mods.cm.asm.dsl.Transformer;
import java.util.function.IntPredicate;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public final class Transformers {
    private static final Hook getSize = mv -> mv.visitMethodInsn(184, "dev/necauqua/mods/cm/EntitySizeManager", "getSize", "(Lnet/minecraft/entity/Entity;)F", false);
    private static final Hook getRenderSize = mv -> mv.visitMethodInsn(184, "dev/necauqua/mods/cm/EntitySizeManager", "getRenderSize", "(Lnet/minecraft/entity/Entity;F)F", false);
    private static final Hook thePlayer = mv -> mv.visitFieldInsn(180, "net/minecraft/client/Minecraft", "field_71439_g", "Lnet/minecraft/client/entity/EntityPlayerSP;");
    private static final Hook scale = mv -> mv.visitMethodInsn(184, "net/minecraft/client/renderer/GlStateManager", "func_179152_a", "(FFF)V", false);
    private static final Hook cutBiggerThanOne = Transformers.cut(149, 158);
    private static final Hook cutSmallerThanOne = Transformers.cut(150, 156);

    private static Hook cut(int compareInsn, int jumpInsn) {
        return mv -> {
            mv.visitInsn(89);
            mv.visitInsn(12);
            mv.visitInsn(compareInsn);
            Label skipOne = new Label();
            mv.visitJumpInsn(jumpInsn, skipOne);
            mv.visitInsn(87);
            mv.visitInsn(12);
            mv.visitLabel(skipOne);
        };
    }

    @Transformer
    public void cameraView() {
        ASM.inClass("net.minecraft.client.renderer.EntityRenderer").addField(2, "$cm_bobbing_dirty_state", "Z").patchMethod("func_78467_g", "(F)V").with(p -> {
            p.addLocal("size", Type.FLOAT_TYPE);
            p.insertBefore(ASM.varInsn(56, 3), mv -> {
                mv.visitVarInsn(25, 2);
                mv.visitHook(getSize);
                mv.visitInsn(110);
                mv.visitVarInsn(25, 2);
                mv.visitVarInsn(23, 1);
                mv.visitHook(getRenderSize);
                mv.visitInsn(89);
                mv.visitVarInsn(56, "size");
                mv.visitInsn(106);
            });
            p.insertBefore(ASM.varInsn(57, 12), mv -> {
                mv.visitVarInsn(23, "size");
                mv.visitInsn(141);
                mv.visitInsn(107);
            });
            p.insertAfterAll(ASM.ldcInsn(Float.valueOf(0.1f)), mv -> {
                mv.visitVarInsn(23, "size");
                mv.visitInsn(106);
            });
            p.insertAfter(ASM.ldcInsn(Float.valueOf(0.05f)), mv -> {
                mv.visitVarInsn(23, "size");
                mv.visitInsn(106);
            });
        }).patchMethod("func_78479_a", "(FI)V").with(p -> {
            p.addLocal("size", Type.FLOAT_TYPE);
            p.insertAfter(ASM.methodBegin(), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, "field_78531_r", "Lnet/minecraft/client/Minecraft;");
                mv.visitHook(thePlayer);
                mv.visitVarInsn(23, 1);
                mv.visitHook(getRenderSize);
                mv.visitVarInsn(56, "size");
            });
            p.insertAfter(ASM.insn(134), mv -> {
                mv.visitVarInsn(23, "size");
                mv.visitHook(cutBiggerThanOne);
                mv.visitInsn(141);
                mv.visitMethodInsn(184, "java/lang/Math", "sqrt", "(D)D", false);
                mv.visitInsn(144);
                mv.visitInsn(106);
            });
            p.insertAfterAll(ASM.ldcInsn(Float.valueOf(0.05f)), mv -> {
                mv.visitVarInsn(23, "size");
                mv.visitInsn(106);
            });
            p.insertAround(ASM.methodInsn(183, "net/minecraft/client/renderer/EntityRenderer", "func_78475_f", "(F)V"), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitInsn(4);
                mv.visitFieldInsn(181, "$cm_bobbing_dirty_state", "Z");
            }, mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitInsn(3);
                mv.visitFieldInsn(181, "$cm_bobbing_dirty_state", "Z");
            });
        }).patchMethod("func_78475_f", "(F)V").with(p -> {
            p.addLocal("size", Type.FLOAT_TYPE);
            p.insertBefore(ASM.varInsn(58, 2), mv -> {
                mv.visitInsn(89);
                mv.visitHook(getSize);
                mv.visitVarInsn(56, "size");
            });
            p.insertAfterAll(ASM.varInsn(23, 5), mv -> {
                if (mv.getPass() > 2) {
                    return;
                }
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, "$cm_bobbing_dirty_state", "Z");
                mv.ifJump(153, () -> {
                    mv.visitVarInsn(23, "size");
                    mv.visitInsn(106);
                });
            });
        }).patchMethod("func_175068_a", "(IFJ)V").and("func_180437_a", "(Lnet/minecraft/client/renderer/RenderGlobal;FI)V").and("func_78476_b", "(FI)V").with(p -> {
            p.addLocal("size", Type.FLOAT_TYPE);
            p.insertAfter(ASM.methodBegin(), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, "field_78531_r", "Lnet/minecraft/client/Minecraft;");
                mv.visitHook(thePlayer);
                mv.visitHook(getSize);
                mv.visitHook(cutBiggerThanOne);
                mv.visitVarInsn(56, "size");
            });
            p.insertAfterAll(ASM.ldcInsn(Float.valueOf(0.05f)), mv -> {
                mv.visitVarInsn(23, "size");
                mv.visitInsn(106);
            });
        });
    }

    @Transformer
    public void entityRender() {
        ASM.inClass("net.minecraft.client.renderer.entity.RenderManager").patchMethod("func_188391_a", "(Lnet/minecraft/entity/Entity;DDDFFZ)V").with(p -> {
            p.addLocal("size", Type.DOUBLE_TYPE);
            p.insertBefore(ASM.varInsn(25, 11), 2, mv -> {
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(23, 9);
                mv.visitHook(getRenderSize);
                mv.visitInsn(89);
                mv.visitInsn(141);
                mv.visitVarInsn(57, "size");
                mv.visitInsn(89);
                mv.visitInsn(89);
                mv.visitHook(scale);
            });
            p.insertAfter(ASM.varInsn(24, 2), mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(111);
            });
            p.insertAfter(ASM.varInsn(24, 4), mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(111);
            });
            p.insertAfter(ASM.varInsn(24, 6), mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(111);
            });
            p.insertBefore(ASM.jumpInsn(167), mv -> {
                mv.visitInsn(12);
                mv.visitVarInsn(24, "size");
                mv.visitInsn(144);
                mv.visitInsn(110);
                mv.visitInsn(89);
                mv.visitInsn(89);
                mv.visitHook(scale);
            });
        }).patchMethod("func_85094_b", "(Lnet/minecraft/entity/Entity;DDDFF)V").with(p -> {
            p.addLocal("size", Type.DOUBLE_TYPE);
            p.insertAfter(ASM.methodBegin(), mv -> {
                mv.visitVarInsn(25, 1);
                mv.visitHook(getSize);
                mv.visitInsn(141);
                mv.visitVarInsn(57, "size");
            });
            p.insertAfterAll(ASM.ldcInsn(2.0), mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(107);
            });
            p.insertAfterAll(ASM.ldcInsn(0.01f), mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(107);
            });
        });
        ASM.inClass("net.minecraft.client.renderer.entity.Render").patchMethod("func_76975_c", "(Lnet/minecraft/entity/Entity;DDDFF)V").with(p -> {
            p.addLocal("size", Type.FLOAT_TYPE);
            p.insertAfter(ASM.methodBegin(), mv -> {
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(23, 9);
                mv.visitHook(getRenderSize);
                mv.visitVarInsn(56, "size");
            });
            p.insertBefore(ASM.varInsn(56, 11), mv -> {
                mv.visitVarInsn(23, "size");
                mv.visitInsn(106);
            });
            p.insertBefore(ASM.varInsn(57, 27), mv -> {
                mv.visitVarInsn(23, "size");
                mv.visitInsn(12);
                mv.visitInsn(150);
                Label skipHook = new Label();
                mv.visitJumpInsn(156, skipHook);
                mv.visitLdcInsn(Float.valueOf(0.015625f));
                mv.visitInsn(12);
                mv.visitVarInsn(23, "size");
                mv.visitInsn(102);
                mv.visitInsn(106);
                mv.visitInsn(141);
                mv.visitInsn(103);
                mv.visitLabel(skipHook);
            });
            p.insertAfter(ASM.varInsn(23, 8), mv -> {
                mv.visitVarInsn(24, 4);
                mv.visitVarInsn(25, 34);
                mv.visitMethodInsn(182, "net/minecraft/util/math/BlockPos", "func_177956_o", "()I", false);
                mv.visitInsn(135);
                mv.visitVarInsn(24, 27);
                mv.visitInsn(99);
                mv.visitInsn(103);
                mv.visitLdcInsn(2.0);
                mv.visitInsn(111);
                mv.visitInsn(144);
                mv.visitInsn(12);
                mv.visitVarInsn(23, "size");
                mv.visitInsn(110);
                mv.visitInsn(12);
                mv.visitInsn(102);
                mv.visitInsn(106);
                mv.visitInsn(102);
            });
        }).patchMethod("func_147906_a", "(Lnet/minecraft/entity/Entity;Ljava/lang/String;DDDI)V").with(p -> {
            p.addLocal("off", Type.FLOAT_TYPE);
            p.replace(ASM.varInsn(23, 16), mv -> {
                mv.visitVarInsn(23, 16);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(182, "net/minecraft/entity/Entity", "func_70093_af", "()Z", false);
                mv.ifJump(153, () -> mv.visitLdcInsn(Float.valueOf(0.25f)), () -> mv.visitLdcInsn(Float.valueOf(0.5f)));
                mv.visitInsn(89);
                mv.visitVarInsn(56, "off");
                mv.visitInsn(102);
                mv.visitVarInsn(25, 1);
                mv.visitHook(getSize);
                mv.visitInsn(110);
                mv.visitVarInsn(23, "off");
                mv.visitInsn(98);
            });
        });
        Patch renderDistPatch = p -> p.insertBefore(ASM.varInsn(57, 3), 3, mv -> {
            mv.visitVarInsn(25, 0);
            mv.visitHook(getSize);
            mv.visitHook(cutBiggerThanOne);
            mv.visitInsn(141);
            mv.visitInsn(111);
        });
        ASM.inClass("net.minecraft.entity.Entity").patchMethodOptionally("func_70112_a", "(D)Z").with(renderDistPatch);
        ASM.inClass("net.minecraft.client.entity.EntityOtherPlayerMP").patchMethod("func_70112_a", "(D)Z").with(renderDistPatch);
        ASM.inClass("net.minecraft.client.gui.inventory.GuiInventory").patchMethod("func_147046_a", "(IIIFFLnet/minecraft/entity/EntityLivingBase;)V").with(p -> p.insertAfter(ASM.varInsn(56, 10), mv -> {
            mv.visitInsn(12);
            mv.visitVarInsn(25, 5);
            mv.visitHook(getSize);
            mv.visitInsn(110);
            mv.visitInsn(89);
            mv.visitInsn(89);
            mv.visitHook(scale);
        }));
    }

    @Transformer
    public void entityMotion() {
        ASM.inClass("net.minecraft.entity.Entity").patchMethod("func_70091_d", "(DDD)V").with(p -> {
            p.addLocal("size", Type.DOUBLE_TYPE);
            p.insertAfter(ASM.methodBegin(), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitHook(getSize);
                mv.visitInsn(141);
                mv.visitVarInsn(57, "size");
                mv.visitVarInsn(24, 1);
                mv.visitVarInsn(24, "size");
                mv.visitInsn(107);
                mv.visitVarInsn(57, 1);
                mv.visitVarInsn(24, 3);
                mv.visitVarInsn(24, "size");
                mv.visitInsn(107);
                mv.visitVarInsn(57, 3);
                mv.visitVarInsn(24, 5);
                mv.visitVarInsn(24, "size");
                mv.visitInsn(107);
                mv.visitVarInsn(57, 5);
            });
            Hook mulBySize = mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(107);
            };
            p.insertAfterAll(ASM.ldcInsn(0.05), mulBySize);
            p.insertBefore(ASM.varInsn(57, 3), 3, mulBySize);
            p.insertAfterAll(ASM.ldcInsn(0.6), mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(111);
            });
            p.insertAfterAll(ASM.ldcInsn(Float.valueOf(0.35f)), mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(144);
                mv.visitInsn(110);
            });
            p.insertAfter(ASM.ldcInsn(0.2f), mulBySize);
        }).patchMethod("func_174808_Z", "()V").with(p -> p.insertAfter(ASM.methodBegin(), mv -> {
            mv.visitVarInsn(25, 0);
            mv.visitHook(getSize);
            mv.visitLdcInsn(Float.valueOf(0.25f));
            mv.visitInsn(150);
            mv.ifJump(157, () -> mv.visitInsn(177));
        }));
        Patch libmSwingAnimation = p -> p.insertAfter(ASM.ldcInsn(Float.valueOf(4.0f)), mv -> {
            mv.visitVarInsn(25, 0);
            mv.visitHook(getSize);
            mv.visitInsn(110);
        });
        ASM.inClass("net.minecraft.entity.EntityLivingBase").patchMethod("func_70612_e", "(FF)V").with(libmSwingAnimation);
        ASM.inClass("net.minecraft.client.entity.EntityOtherPlayerMP").patchMethod("func_70071_h_", "()V").with(libmSwingAnimation);
        ASM.inClass("net.minecraft.client.entity.EntityPlayerSP").patchMethod("func_189810_i", "(FF)V").with(p -> {
            p.addLocal("size", Type.FLOAT_TYPE);
            p.insertAfter(ASM.ldcInsn(Float.valueOf(0.001f)), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitHook(getSize);
                mv.visitInsn(89);
                mv.visitVarInsn(56, "size");
                mv.visitInsn(106);
            });
            Hook mulBySize = mv -> {
                mv.visitVarInsn(23, "size");
                mv.visitInsn(106);
            };
            p.insertAfter(ASM.ldcInsn(Float.valueOf(0.001f)), 2, mulBySize);
            p.insertAfter(ASM.ldcInsn(Float.valueOf(-0.15f)), mulBySize);
            p.insertAfter(ASM.ldcInsn(Float.valueOf(7.0f)), 2, mulBySize);
            p.insertAfter(ASM.ldcInsn(Float.valueOf(0.75f)), mulBySize);
            p.insertAfter(ASM.ldcInsn(Float.valueOf(1.2f)), mulBySize);
            p.insertAfter(ASM.ldcInsn(Float.valueOf(0.5f)), 2, mulBySize);
            p.replace(ASM.insn(4), 2, mv -> mv.visitInsn(3));
            p.insertAfterAll(ASM.ldcInsn(0.51f), mv -> {
                mv.visitVarInsn(23, "size");
                mv.visitInsn(141);
                mv.visitInsn(107);
            });
        });
    }

    @Transformer
    public void serverMotionFixes() {
        ASM.inClass("net.minecraft.client.entity.EntityPlayerSP").patchMethod("func_175161_p", "()V").with(p -> p.insertAfter(ASM.ldcInsn(9.0E-4), mv -> {
            mv.visitVarInsn(25, 0);
            mv.visitHook(getSize);
            mv.visitInsn(141);
            mv.visitInsn(92);
            mv.visitInsn(107);
            mv.visitInsn(107);
        }));
        ASM.inClass("net.minecraft.entity.EntityTrackerEntry").patchMethod("func_73122_a", "(Ljava/util/List;)V").with(p -> p.replace(ASM.ldcInsn(128L), mv -> {
            mv.visitLdcInsn(Float.valueOf(128.0f));
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "field_73132_a", "Lnet/minecraft/entity/Entity;");
            mv.visitHook(getSize);
            mv.visitInsn(89);
            mv.visitInsn(106);
            mv.visitInsn(106);
            mv.visitInsn(140);
        }));
        ASM.inClass("net.minecraft.network.NetHandlerPlayServer").patchMethod("func_147347_a", "(Lnet/minecraft/network/play/client/CPacketPlayer;)V").with(p -> {
            p.addLocal("size", Type.DOUBLE_TYPE);
            p.insertBefore(ASM.varInsn(25, 2), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, "field_147369_b", "Lnet/minecraft/entity/player/EntityPlayerMP;");
                mv.visitHook(getSize);
                mv.visitInsn(141);
                mv.visitVarInsn(57, "size");
            });
            p.insertAfter(ASM.varInsn(24, 19), 4, mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(111);
            });
            p.insertAfter(ASM.varInsn(24, 21), 5, mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(111);
            });
            p.insertAfter(ASM.varInsn(24, 23), 4, mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(111);
            });
            p.insertAfterAll(ASM.ldcInsn(0.0625), mv -> {
                if (mv.getPass() != 2) {
                    mv.visitVarInsn(24, "size");
                    mv.visitInsn(107);
                }
            });
        });
    }

    @Transformer
    public void entityCollisions() {
        ASM.inClass("net.minecraft.entity.player.EntityPlayer").patchMethod("func_184808_cD", "()V").with(p -> {
            p.addLocal("size", Type.FLOAT_TYPE);
            p.insertBefore(ASM.varInsn(23, 1), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitHook(getSize);
                mv.visitInsn(89);
                mv.visitInsn(89);
                mv.visitVarInsn(56, "size");
                mv.visitVarInsn(23, 1);
                mv.visitInsn(106);
                mv.visitVarInsn(56, 1);
                mv.visitVarInsn(23, 2);
                mv.visitInsn(106);
                mv.visitVarInsn(56, 2);
            });
        }).patchMethod("func_70636_d", "()V").with(p -> {
            p.addLocal("size", Type.DOUBLE_TYPE);
            p.insertBefore(ASM.jumpInsn(153), 5, mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitHook(getSize);
                mv.visitInsn(141);
                mv.visitVarInsn(57, "size");
            });
            p.replaceAll(ASM.insn(15), mv -> mv.visitVarInsn(24, "size"));
            p.insertAfter(ASM.ldcInsn(0.5), mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(107);
            });
        });
        Label skipBlockCollision = new Label();
        ASM.inClass("net.minecraft.entity.Entity").patchMethod("func_70071_h_", "()V").with(p -> p.insertAfter(ASM.methodBegin(), mv -> {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "dev/necauqua/mods/cm/EntitySizeManager", "updateSize", "(Lnet/minecraft/entity/Entity;)V", false);
        })).patchMethod("func_70094_T", "()Z").with(p -> p.insertAfter(ASM.ldcInsn(Float.valueOf(0.1f)), mv -> {
            mv.visitVarInsn(25, 0);
            mv.visitHook(getSize);
            mv.visitInsn(106);
        })).patchMethod("func_145775_I", "()V").with(p -> {
            p.insertBefore(ASM.varInsn(25, 8), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 8);
                mv.visitVarInsn(25, 4);
                mv.visitMethodInsn(184, "dev/necauqua/mods/cm/Hooks", "cancelBlockCollision", "(Lnet/minecraft/entity/Entity;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;)Z", false);
                mv.visitJumpInsn(154, skipBlockCollision);
            });
            p.insertAfter(ASM.methodInsn(182, "net/minecraft/block/Block", "func_180634_a", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;)V"), mv -> mv.visitLabel(skipBlockCollision));
        });
        ASM.inClass("net.minecraft.entity.monster.EntitySkeleton").patchMethod("func_189769_b", "(Lnet/minecraft/entity/monster/SkeletonType;)V").with(p -> {
            p.addLocal("size", Type.FLOAT_TYPE);
            p.insertAfter(ASM.methodBegin(), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitHook(getSize);
                mv.visitVarInsn(56, "size");
            });
            Hook mulBySize = mv -> {
                mv.visitVarInsn(23, "size");
                mv.visitInsn(106);
            };
            p.insertAfter(ASM.ldcInsn(Float.valueOf(0.7f)), mulBySize);
            p.insertAfter(ASM.ldcInsn(Float.valueOf(2.4f)), mulBySize);
            p.insertAfter(ASM.ldcInsn(Float.valueOf(0.6f)), mulBySize);
            p.insertAfter(ASM.ldcInsn(Float.valueOf(1.99f)), mulBySize);
        });
    }

    @Transformer
    public void reachDistance() {
        ASM.inClass("net.minecraft.client.renderer.EntityRenderer").patchMethod("func_78473_a", "(F)V").with(p -> {
            p.addLocal("size", Type.DOUBLE_TYPE);
            p.insertBefore(ASM.varInsn(57, 3), mv -> {
                mv.visitVarInsn(25, 2);
                mv.visitVarInsn(23, 1);
                mv.visitHook(getRenderSize);
                mv.visitInsn(141);
                mv.visitVarInsn(57, "size");
                mv.visitVarInsn(24, "size");
                mv.visitInsn(107);
            });
            Hook mulBySize = mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(107);
            };
            p.insertAfter(ASM.ldcInsn(6.0), mulBySize);
            p.insertAfterAll(ASM.ldcInsn(3.0), mulBySize);
        });
        ASM.inClass("net.minecraft.client.multiplayer.PlayerControllerMP").patchMethod("func_78757_d", "()F").with(p -> p.insertBefore(ASM.insn(174), mv -> {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "field_78776_a", "Lnet/minecraft/client/Minecraft;");
            mv.visitHook(thePlayer);
            mv.visitHook(getSize);
            mv.visitHook(cutSmallerThanOne);
            mv.visitInsn(106);
        }));
        ASM.inClass("net.minecraft.server.management.PlayerInteractionManager").patchMethod("getBlockReachDistance", "()D").with(p -> p.insertBefore(ASM.insn(175), mv -> {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "field_73090_b", "Lnet/minecraft/entity/player/EntityPlayerMP;");
            mv.visitHook(getSize);
            mv.visitHook(cutSmallerThanOne);
            mv.visitInsn(141);
            mv.visitInsn(107);
        }));
        ASM.inClass("net.minecraft.network.NetHandlerPlayServer").patchMethod("func_147340_a", "(Lnet/minecraft/network/play/client/CPacketUseEntity;)V").with(p -> p.insertAfter(ASM.varInsn(24, 5), mv -> {
            mv.visitVarInsn(25, 3);
            mv.visitHook(getSize);
            mv.visitHook(cutSmallerThanOne);
            mv.visitInsn(141);
            mv.visitInsn(92);
            mv.visitInsn(107);
            mv.visitInsn(107);
        }));
        ASM.inClass("net.minecraft.world.World").patchMethod("func_147447_a", "(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;ZZZ)Lnet/minecraft/util/math/RayTraceResult;").with(p -> p.replace(ASM.insn(1), mv -> {
            mv.visitTypeInsn(187, "net/minecraft/util/math/RayTraceResult");
            mv.visitInsn(89);
            mv.visitFieldInsn(178, "net/minecraft/util/math/RayTraceResult$Type", "MISS", "Lnet/minecraft/util/math/RayTraceResult$Type;");
            mv.visitVarInsn(25, 1);
            mv.visitInsn(1);
            mv.visitTypeInsn(192, "net/minecraft/util/EnumFacing");
            mv.visitTypeInsn(187, "net/minecraft/util/math/BlockPos");
            mv.visitInsn(89);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(183, "net/minecraft/util/math/BlockPos", "<init>", "(Lnet/minecraft/util/math/Vec3d;)V", false);
            mv.visitMethodInsn(183, "net/minecraft/util/math/RayTraceResult", "<init>", "(Lnet/minecraft/util/math/RayTraceResult$Type;Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/EnumFacing;Lnet/minecraft/util/math/BlockPos;)V", false);
        }));
    }

    @Transformer
    public void eyeHeight() {
        Patch mulBySize = p -> p.insertBefore(ASM.insn(174), mv -> {
            mv.visitVarInsn(25, 0);
            mv.visitHook(getSize);
            mv.visitInsn(106);
        });
        ASM.inClass("net.minecraft.entity.player.EntityPlayer").patchMethod("func_70047_e", "()F").with(mulBySize);
        ASM.inClass("net.minecraft.entity.monster.EntitySkeleton").patchMethod("func_70047_e", "()F").with(mulBySize);
        ASM.inClass("net.minecraft.entity.monster.EntitySnowman").patchMethod("func_70047_e", "()F").with(mulBySize);
        ASM.inClass("net.minecraft.entity.monster.EntityGhast").patchMethod("func_70047_e", "()F").with(mulBySize);
        ASM.inClass("net.minecraft.entity.monster.EntityWitch").patchMethod("func_70047_e", "()F").with(mulBySize);
    }

    @Transformer
    public void itemFixes() {
        ASM.inClass("net.minecraft.entity.item.EntityItem").patchMethod("func_85054_d", "()V").with(p -> {
            p.addLocal("size", Type.DOUBLE_TYPE);
            p.insertAfter(ASM.methodBegin(), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitHook(getSize);
                mv.visitInsn(141);
                mv.visitVarInsn(57, "size");
            });
            p.insertAfterAll(ASM.ldcInsn(0.5), mv -> {
                mv.visitVarInsn(24, "size");
                mv.visitInsn(107);
            });
        });
        ASM.inClass("net.minecraft.client.particle.ParticleItemPickup").patchConstructor("(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/Entity;F)V").with(p -> p.insertAfter(ASM.varInsn(23, 4), mv -> {
            mv.visitVarInsn(25, 3);
            mv.visitHook(getSize);
            mv.visitInsn(106);
        }));
        ASM.inClass("net.minecraft.entity.player.EntityPlayer").patchMethod("func_146097_a", "(Lnet/minecraft/item/ItemStack;ZZ)Lnet/minecraft/entity/item/EntityItem;").with(p -> p.insertAfter(ASM.ldcInsn(0.3f), mv -> {
            mv.visitVarInsn(25, 0);
            mv.visitHook(getSize);
            mv.visitInsn(141);
            mv.visitInsn(107);
        }));
        ASM.inClass("net.minecraft.entity.Entity").patchMethod("func_70099_a", "(Lnet/minecraft/item/ItemStack;F)Lnet/minecraft/entity/item/EntityItem;").with(p -> {
            p.addLocal("size", Type.FLOAT_TYPE);
            p.insertAfter(ASM.varInsn(23, 2), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitHook(getSize);
                mv.visitInsn(89);
                mv.visitVarInsn(56, "size");
                mv.visitInsn(106);
            });
            p.insertBefore(ASM.varInsn(58, 3), mv -> {
                mv.visitInsn(89);
                mv.visitVarInsn(23, "size");
                mv.visitInsn(4);
                mv.visitMethodInsn(184, "dev/necauqua/mods/cm/EntitySizeManager", "setSize", "(Lnet/minecraft/entity/Entity;FZ)V", false);
            });
        });
    }

    @Transformer
    public void beaconBaseColor() {
        String WHITE = "WHITE";
        ASM.inClass("net.minecraft.tileentity.TileEntityBeacon").addField(2, "$cm_baseColor", "Lnet/minecraft/item/EnumDyeColor;").patchConstructor("()V").with(p -> p.insertAfter(ASM.varInsn(25, 0), 2, mv -> {
            mv.visitInsn(89);
            mv.visitFieldInsn(178, "net/minecraft/item/EnumDyeColor", WHITE, "Lnet/minecraft/item/EnumDyeColor;");
            mv.visitFieldInsn(181, "$cm_baseColor", "Lnet/minecraft/item/EnumDyeColor;");
        })).patchMethod("func_146003_y", "()V").with(p -> p.replace(ASM.fieldInsn(178, "net/minecraft/item/EnumDyeColor", WHITE, "Lnet/minecraft/item/EnumDyeColor;"), mv -> {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "$cm_baseColor", "Lnet/minecraft/item/EnumDyeColor;");
        })).patchMethod("func_145839_a", "(Lnet/minecraft/nbt/NBTTagCompound;)V").with(p -> p.insertAfter(ASM.methodBegin(), mv -> {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn("chiseled_me:color");
            mv.visitMethodInsn(182, "net/minecraft/nbt/NBTTagCompound", "func_74771_c", "(Ljava/lang/String;)B", false);
            mv.visitMethodInsn(184, "net/minecraft/item/EnumDyeColor", "func_176764_b", "(I)Lnet/minecraft/item/EnumDyeColor;", false);
            mv.visitFieldInsn(181, "$cm_baseColor", "Lnet/minecraft/item/EnumDyeColor;");
        })).patchMethod("func_189515_b", "(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;").with(p -> p.insertAfter(ASM.methodBegin(), mv -> {
            mv.visitVarInsn(25, 1);
            mv.visitLdcInsn("chiseled_me:color");
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "$cm_baseColor", "Lnet/minecraft/item/EnumDyeColor;");
            mv.visitMethodInsn(182, "net/minecraft/item/EnumDyeColor", "func_176765_a", "()I", false);
            mv.visitInsn(145);
            mv.visitMethodInsn(182, "net/minecraft/nbt/NBTTagCompound", "func_74774_a", "(Ljava/lang/String;B)V", false);
        }));
    }

    private Patch motionPatchFor(IntPredicate filterXZ, IntPredicate filterY) {
        return p -> {
            p.insertAfter(ASM.methodBegin(), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitInsn(89);
                mv.visitHook(getSize);
                mv.visitInsn(141);
                mv.visitFieldInsn(181, "$cm_size", "D");
            });
            Hook mulBySize = mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, "$cm_size", "D");
                mv.visitInsn(107);
            };
            Hook filtered = mulBySize.filter(filterXZ);
            Hook filteredY = mulBySize.filter(filterY);
            String className = p.getClassName();
            p.insertAfterAll(ASM.fieldInsn(180, className, "field_70159_w", "D"), filtered);
            p.insertAfterAll(ASM.fieldInsn(180, className, "field_70181_x", "D"), filteredY);
            p.insertAfterAll(ASM.fieldInsn(180, className, "field_70179_y", "D"), filtered);
            p.insertAfterAll(ASM.ldcInsn(0.25), mulBySize);
        };
    }

    @Transformer
    public void throwableEntityMotion() {
        Hook mulBySize = mv -> {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "$cm_size", "D");
            mv.visitInsn(107);
        };
        Patch heightPatch = p -> p.insertAfter(ASM.ldcInsn(0.1f), mv -> {
            mv.visitVarInsn(25, 2);
            mv.visitHook(getSize);
            mv.visitInsn(141);
            mv.visitInsn(107);
        });
        Patch collisionPatch = p -> {
            p.replace(ASM.insn(15), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, "$cm_size", "D");
            });
            p.insertAfterAll(ASM.ldcInsn(0.3f), mulBySize);
        };
        Patch sizeFieldPatch = p -> {
            p.insertAfter(ASM.methodBegin(), mv -> {
                mv.visitVarInsn(25, 0);
                mv.visitInsn(89);
                mv.visitHook(getSize);
                mv.visitInsn(141);
                mv.visitFieldInsn(181, "$cm_size", "D");
            });
            p.insertAfterAll(ASM.ldcInsn(0.25), mulBySize);
        };
        ASM.inClass("net.minecraft.entity.projectile.EntityThrowable").addField(2, "$cm_size", "D").patchConstructor("(Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;)V").with(heightPatch).patchMethod("func_70071_h_", "()V").with(sizeFieldPatch.and(collisionPatch).and(this.motionPatchFor(pass -> pass >= 2 && pass <= 5 || pass == 9 || pass == 10, pass -> pass >= 2 && pass <= 5 || pass == 7 || pass == 8)));
        ASM.inClass("net.minecraft.entity.projectile.EntityArrow").addField(2, "$cm_size", "D").patchConstructor("(Lnet/minecraft/world/World;Lnet/minecraft/entity/EntityLivingBase;)V").with(heightPatch).patchMethod("func_70071_h_", "()V").with(sizeFieldPatch.and(this.motionPatchFor(pass -> pass >= 5 && pass <= 9 || pass == 13 || pass == 14, pass -> pass >= 3 && pass <= 7 || pass == 9 || pass == 10)).and(p -> p.insertAfter(ASM.methodInsn(182, "net/minecraft/entity/projectile/EntityArrow", "func_70241_g", "()Z"), mv -> mv.ifJump(153, () -> {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "$cm_size", "D");
            mv.visitInsn(144);
            mv.visitLdcInsn(Float.valueOf(0.25f));
            mv.visitInsn(150);
            mv.ifJump(157, () -> mv.visitInsn(3), () -> mv.visitInsn(4));
        }, () -> mv.visitInsn(3))))).patchMethod("func_184551_a", "(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/util/math/Vec3d;)Lnet/minecraft/entity/Entity;").with(collisionPatch).patchMethod("func_184549_a", "(Lnet/minecraft/util/math/RayTraceResult;)V").with(p -> p.insertAfterAll(ASM.ldcInsn(0.05f), mulBySize));
    }
}

