/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.asm.dsl;

import dev.necauqua.mods.cm.ChiseledMe;
import dev.necauqua.mods.cm.Log;
import dev.necauqua.mods.cm.asm.dsl.ClassPatchVisitor;
import dev.necauqua.mods.cm.asm.dsl.ClassPatcher;
import dev.necauqua.mods.cm.asm.dsl.MethodPatcher;
import dev.necauqua.mods.cm.asm.dsl.Transformer;
import dev.necauqua.mods.cm.asm.dsl.anchors.Anchor;
import dev.necauqua.mods.cm.asm.dsl.anchors.FieldInsnAnchor;
import dev.necauqua.mods.cm.asm.dsl.anchors.InsnAnchor;
import dev.necauqua.mods.cm.asm.dsl.anchors.JumpInsnAnchor;
import dev.necauqua.mods.cm.asm.dsl.anchors.LdcInsnAnchor;
import dev.necauqua.mods.cm.asm.dsl.anchors.MethodBeginAnchor;
import dev.necauqua.mods.cm.asm.dsl.anchors.MethodInsnAnchor;
import dev.necauqua.mods.cm.asm.dsl.anchors.VarInsnAnchor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class ASM {
    private static boolean loadedAtAll = false;
    private static final Map<String, ClassPatcher> patchers = new HashMap<String, ClassPatcher>();
    static String currentTransformer = null;

    private ASM() {
    }

    public static void check() {
        if (!loadedAtAll) {
            Log.error("\n  ****************************************************************************************************\n  * For some reason coremod part of the mod was not even loaded at all!\n  * Something is completely wrong - corrupt jar-file, manifest etc.\n  * Redownload the mod, ensuring that Minecraft and Forge versions are the ones required and so on.\n  ****************************************************************************************************");
            throw new IllegalStateException("Coremod was not loaded!");
        }
    }

    public static void init(Object holder) {
        loadedAtAll = true;
        for (Method m : holder.getClass().getMethods()) {
            if (!m.isAnnotationPresent(Transformer.class)) continue;
            try {
                currentTransformer = m.getName();
                m.invoke(holder, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't load transformer '" + m.getName() + "'!", e);
            }
        }
        currentTransformer = null;
    }

    public static byte[] doTransform(String className, byte[] original) {
        ClassPatcher patcher = patchers.get(className);
        if (patcher == null) {
            return original;
        }
        Log.debug("Patching class: " + className);
        ClassReader reader = new ClassReader(original);
        ClassWriter writer = new ClassWriter(reader, 2){

            protected String getCommonSuperClass(String type1, String type2) {
                Class<?> d;
                Class<?> c;
                ClassLoader classLoader = ChiseledMe.class.getClassLoader();
                try {
                    c = Class.forName(type1.replace('/', '.'), false, classLoader);
                    d = Class.forName(type2.replace('/', '.'), false, classLoader);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.toString());
                }
                if (c.isAssignableFrom(d)) {
                    return type1;
                }
                if (d.isAssignableFrom(c)) {
                    return type2;
                }
                if (c.isInterface() || d.isInterface()) {
                    return "java/lang/Object";
                }
                while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
                }
                return c.getName().replace('.', '/');
            }
        };
        ClassPatchVisitor visitor = new ClassPatchVisitor((ClassVisitor)writer, patcher);
        reader.accept((ClassVisitor)visitor, 4);
        byte[] modified = writer.toByteArray();
        ASM.checkMisses(className, visitor);
        return modified;
    }

    private static void checkMisses(String className, ClassPatchVisitor visitor) {
        List missedModifiers;
        String shortName = className.substring(className.lastIndexOf(46) + 1);
        StringBuilder message = new StringBuilder();
        List missedMethods = visitor.getMissedMethods().stream().filter(mp -> {
            if (mp.isOptional()) {
                Log.debug("Missed optional method(s) " + mp.getMethodNames());
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        if (!missedMethods.isEmpty()) {
            message.append("Some methods were not found in class ").append(shortName).append(":\n");
            missedMethods.stream().collect(Collectors.groupingBy(MethodPatcher::getTransformerName)).forEach((transformer, mps) -> {
                message.append("  transformer '").append((String)transformer).append("':\n");
                mps.forEach(mp -> message.append("    method(s) ").append(mp.getMethodNames()).append('\n'));
            });
        }
        if (!(missedModifiers = visitor.getMissedModifiers().stream().filter(m -> {
            if (m.getParent().isOptional()) {
                Log.debug("Missed optional modifier " + m);
                return false;
            }
            return true;
        }).collect(Collectors.toList())).isEmpty()) {
            message.append("Some patches were not applied to class ").append(shortName).append(":\n");
            missedModifiers.stream().collect(Collectors.groupingBy(m -> m.getParent().getTransformerName())).forEach((transformer, transformerMisses) -> {
                message.append("  transformer '").append((String)transformer).append("':\n");
                transformerMisses.stream().collect(Collectors.groupingBy(modifier -> modifier.getParent().getMethodNames())).forEach((method, methodMisses) -> {
                    message.append("    method ").append((String)method).append(":\n");
                    methodMisses.forEach(m -> message.append("      - ").append(m).append('\n'));
                });
            });
        }
        if (message.length() > 0) {
            throw new IllegalStateException("Coremod failed!\n" + message);
        }
    }

    public static String srg(String mcpName) {
        return mcpName;
    }

    public static String srg(String mcpName, String className) {
        return mcpName;
    }

    public static String srg(String mcpName, String className, String methodDesc) {
        return mcpName;
    }

    public static ClassPatcher inClass(String className) {
        if (currentTransformer == null) {
            throw new IllegalStateException("Can't use 'inClass' outside transformer method!");
        }
        return patchers.computeIfAbsent(className, ClassPatcher::new);
    }

    public static Anchor methodBegin() {
        return MethodBeginAnchor.INSTANCE;
    }

    public static Anchor insn(int opcode) {
        return new InsnAnchor(opcode);
    }

    public static Anchor ldcInsn(Object cst) {
        return new LdcInsnAnchor(cst);
    }

    public static Anchor varInsn(int opcode, int var) {
        return new VarInsnAnchor(opcode, var);
    }

    public static Anchor jumpInsn(int opcode) {
        return new JumpInsnAnchor(opcode);
    }

    public static Anchor fieldInsn(int opcode, String owner, String name, String desc) {
        return new FieldInsnAnchor(opcode, owner, name, desc);
    }

    public static Anchor methodInsn(int opcode, String owner, String name, String desc) {
        return new MethodInsnAnchor(opcode, owner, name, desc);
    }
}

