/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.asm.dsl;

import dev.necauqua.mods.cm.Log;
import dev.necauqua.mods.cm.asm.dsl.ClassPatcher;
import dev.necauqua.mods.cm.asm.dsl.ContextMethodVisitor;
import dev.necauqua.mods.cm.asm.dsl.MethodDumper;
import dev.necauqua.mods.cm.asm.dsl.MethodPatcher;
import dev.necauqua.mods.cm.asm.dsl.Modifier;
import dev.necauqua.mods.cm.asm.dsl.PatchContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.LocalVariablesSorter;

public final class ClassPatchVisitor
extends ClassVisitor {
    private final ClassPatcher patcher;
    private final List<Modifier> modifiers = new ArrayList<Modifier>();
    private final List<MethodPatcher> missedMethods = new ArrayList<MethodPatcher>();
    private final List<Modifier> missedModifiers = new ArrayList<Modifier>();

    public ClassPatchVisitor(ClassVisitor parent, ClassPatcher patcher) {
        super(327680, parent);
        this.patcher = patcher;
    }

    public List<MethodPatcher> getMissedMethods() {
        return this.missedMethods;
    }

    public List<Modifier> getMissedModifiers() {
        return this.missedModifiers;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        for (ClassPatcher.FieldDesc f : this.patcher.getFields()) {
            Log.debug("  - Adding field: " + f.getName() + "(" + f.getDesc() + ")");
            this.cv.visitField(f.getAcc(), f.getName(), f.getDesc(), f.getSign(), null).visitEnd();
        }
    }

    public void visitEnd() {
        super.visitEnd();
        this.patcher.getMethodPatchers().stream().filter(mp -> !mp.didMatch()).forEach(this.missedMethods::add);
        this.modifiers.stream().filter(m -> !m.didMatch()).forEach(this.missedModifiers::add);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        ArrayList<Modifier> modifiers = new ArrayList<Modifier>();
        ArrayList<Pair<String, Type>> locals = new ArrayList<Pair<String, Type>>();
        boolean isDump = false;
        for (MethodPatcher methodPatcher : this.patcher.getMethodPatchers()) {
            for (Pair<String, String> md : methodPatcher.getMethodsToPatch()) {
                if (!((String)md.getLeft()).equals(name) || !((String)md.getRight()).equals(desc)) continue;
                PatchContext context = new PatchContext(methodPatcher);
                methodPatcher.apply(context);
                isDump |= context.isDump();
                modifiers.addAll(context.getModifiers());
                locals.addAll(context.getLocals());
            }
        }
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (modifiers.isEmpty()) {
            return visitor;
        }
        this.modifiers.addAll(modifiers);
        String className = this.patcher.getClassName();
        if (isDump) {
            visitor = MethodDumper.create(visitor, "patched", className, name + desc);
        }
        LocalVariablesSorter lvs = new LocalVariablesSorter(access, desc, visitor);
        Map<String, Integer> localIndices = locals.stream().collect(Collectors.toMap(Pair::getLeft, p -> lvs.newLocal((Type)p.getRight())));
        ContextMethodVisitor patched = new ContextMethodVisitor(className, localIndices, (MethodVisitor)lvs, visitor);
        for (Modifier mod : modifiers) {
            patched = mod.apply(patched);
        }
        if (isDump) {
            return MethodDumper.create(patched, "original", className, name + desc);
        }
        return patched;
    }
}

