/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.asm.dsl;

import dev.necauqua.mods.cm.asm.dsl.ASM;
import dev.necauqua.mods.cm.asm.dsl.ClassPatcherDsl;
import dev.necauqua.mods.cm.asm.dsl.MethodPatcher;
import dev.necauqua.mods.cm.asm.dsl.MethodPatcherDsl;
import java.util.ArrayList;
import java.util.List;

public final class ClassPatcher
implements ClassPatcherDsl {
    private final String className;
    private final List<FieldDesc> fields = new ArrayList<FieldDesc>();
    private final List<MethodPatcher> methodPatchers = new ArrayList<MethodPatcher>();

    public ClassPatcher(String className) {
        this.className = className;
    }

    public List<MethodPatcher> getMethodPatchers() {
        return this.methodPatchers;
    }

    public List<FieldDesc> getFields() {
        return this.fields;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public ClassPatcherDsl addField(int acc, String name, String desc, String sign) {
        this.fields.add(new FieldDesc(acc, name, desc, sign));
        return this;
    }

    @Override
    public ClassPatcherDsl addField(int acc, String name, String desc) {
        return this.addField(acc, name, desc, null);
    }

    @Override
    public MethodPatcherDsl patchConstructor(String desc) {
        return this.patchMethod("<init>", desc);
    }

    @Override
    public MethodPatcherDsl patchMethod(String name, String desc) {
        MethodPatcher patch = new MethodPatcher(this, ASM.currentTransformer, name, desc, false);
        this.methodPatchers.add(patch);
        return patch;
    }

    @Override
    public MethodPatcherDsl patchMethodOptionally(String name, String desc) {
        MethodPatcher patch = new MethodPatcher(this, ASM.currentTransformer, name, desc, true);
        this.methodPatchers.add(patch);
        return patch;
    }

    public static final class FieldDesc {
        private final int acc;
        private final String name;
        private final String desc;
        private final String sign;

        public FieldDesc(int acc, String name, String desc, String sign) {
            this.acc = acc;
            this.name = name;
            this.desc = desc;
            this.sign = sign;
        }

        public int getAcc() {
            return this.acc;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getSign() {
            return this.sign;
        }
    }
}

