/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.asm.dsl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceMethodVisitor;

public final class MethodDumper
extends MethodVisitor {
    private static final Path DUMP_DIR = Paths.get("./dumps", new String[0]);
    private final String classifier;
    private final String className;
    private final String name;
    private final TraceMethodVisitor tmv;

    private MethodDumper(String classifier, String className, String name, TraceMethodVisitor tmv) {
        super(327680, (MethodVisitor)tmv);
        this.classifier = classifier;
        this.className = className;
        this.name = name;
        this.tmv = tmv;
    }

    public static MethodVisitor create(MethodVisitor parent, String header, String className, String name) {
        return new MethodDumper(header, className, name, new TraceMethodVisitor(parent, (Printer)new Textifier()));
    }

    public void visitEnd() {
        super.visitEnd();
        try {
            Files.createDirectories(DUMP_DIR, new FileAttribute[0]);
            String filename = this.className.replace('.', '_') + "#" + this.name.replace('/', '_') + "-" + this.classifier + ".dump";
            PrintWriter writer = new PrintWriter(new FileOutputStream(DUMP_DIR.resolve(filename).toFile()));
            writer.print('\n' + this.classifier.toUpperCase() + " DUMP OF METHOD " + this.name + '\n');
            this.tmv.p.print(writer);
            writer.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

