/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.item;

import dev.necauqua.mods.cm.Achievements;
import dev.necauqua.mods.cm.ChiseledMe;
import dev.necauqua.mods.cm.Config;
import dev.necauqua.mods.cm.EntitySizeManager;
import dev.necauqua.mods.cm.Network;
import dev.necauqua.mods.cm.item.ItemMod;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public final class ItemRecalibrator
extends ItemMod {
    public static final IBehaviorDispenseItem DISPENSER_BEHAVIOR = (source, stack) -> {
        BlockPos at = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
        List list = source.func_82618_k().func_72872_a(Entity.class, new AxisAlignedBB(at));
        if (list.isEmpty()) {
            return stack;
        }
        RecalibrationEffect effect = ItemRecalibrator.getEffectFromStack(stack);
        ItemStack worked = stack.func_77946_l();
        for (Entity entity : list) {
            worked = effect.apply(entity, worked);
        }
        return worked;
    };

    public ItemRecalibrator() {
        super("recalibrator");
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DISPENSER_BEHAVIOR);
        this.func_77625_d(1);
    }

    public static RecalibrationEffect getEffectFromStack(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b("type", 1) && nbt.func_150297_b("tier", 1) && nbt.func_150297_b("charges", 3)) {
            return new RecalibrationEffect(nbt.func_74771_c("type"), nbt.func_74771_c("tier"), nbt.func_74762_e("charges"));
        }
        return new RecalibrationEffect(0, 0, 0);
    }

    public static ItemStack create(byte type, byte tier) {
        ItemStack stack = new ItemStack((Item)ChiseledMe.RECALIBRATOR);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("type", type);
        nbt.func_74774_a("tier", tier);
        nbt.func_74768_a("charges", 0);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        ItemStack ret = stack;
        double dist = Config.recalibratorEntityReachDist;
        if (dist > 0.0 && player.func_70093_af()) {
            Vec3d start = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
            Vec3d end = start.func_178787_e(player.func_70676_i(1.0f).func_186678_a(dist));
            AxisAlignedBB range = new AxisAlignedBB(player.field_70165_t - dist, player.field_70163_u - dist, player.field_70161_v - dist, player.field_70165_t + dist, player.field_70163_u + dist, player.field_70161_v + dist);
            Entity target = null;
            for (Entity entity : world.func_72839_b((Entity)player, range)) {
                double d;
                RayTraceResult result;
                AxisAlignedBB aabb = entity.func_174813_aQ();
                if (Config.recalibratorItemEntityBBoxOffset && entity instanceof EntityItem) {
                    double h = aabb.field_72337_e - aabb.field_72338_b;
                    aabb = new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b + h, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e + h, aabb.field_72334_f);
                }
                if ((result = aabb.func_72327_a(start, end)) == null || !((d = start.func_72438_d(entity.func_174791_d())) < dist)) continue;
                dist = d;
                target = entity;
            }
            if (target != null && !target.func_82150_aj() && !(target instanceof EntityPlayer)) {
                ret = ItemRecalibrator.getEffectFromStack(stack).apply(target, stack.func_77946_l());
            }
        } else {
            ret = ItemRecalibrator.getEffectFromStack(stack).apply((Entity)player, stack.func_77946_l());
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)(player.func_184812_l_() ? stack : ret));
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return ItemRecalibrator.getEffectFromStack(stack).getDisplayString("name");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        RecalibrationEffect effect = ItemRecalibrator.getEffectFromStack(stack);
        tooltip.add(effect.getDisplayString("tooltip"));
        String uses = effect.getChargesLeft();
        if (uses != null) {
            tooltip.add(uses);
        }
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        RecalibrationEffect effect = ItemRecalibrator.getEffectFromStack(stack);
        return effect.type == 0 ? EnumRarity.UNCOMMON : (effect.tier <= (effect.type == -1 ? (byte)8 : 2) ? EnumRarity.RARE : EnumRarity.EPIC);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemRecalibrator.getEffectFromStack(stack).showBar();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ItemRecalibrator.getEffectFromStack(stack).getBar();
    }

    public void func_150895_a(@Nonnull Item item, @Nullable CreativeTabs tab, List<ItemStack> subItems) {
        byte i;
        super.func_150895_a(item, tab, subItems);
        for (i = 1; i <= 12; i = (byte)(i + 1)) {
            subItems.add(ItemRecalibrator.create((byte)-1, i));
        }
        for (i = 1; i <= 4; i = (byte)(i + 1)) {
            subItems.add(ItemRecalibrator.create((byte)1, i));
        }
    }

    @Override
    protected ResourceLocation getModelResource(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        byte type = nbt != null ? nbt.func_74771_c("type") : (byte)0;
        return new ResourceLocation("chiseled_me", "recalibrator" + (type == -1 ? "_reduction" : (type == 1 ? "_amplification" : "")));
    }

    @Override
    protected String[] getModelVariants() {
        return new String[]{"recalibrator_reduction", "recalibrator_amplification"};
    }

    public static class RecalibrationEffect {
        public static final byte REDUCTION = -1;
        public static final byte RESET = 0;
        public static final byte AMPLIFICATION = 1;
        private final byte type;
        private final byte tier;
        private final int charges;
        private final float size;
        private final float maxCharges;

        public RecalibrationEffect(byte type, byte tier, int charges) {
            this.type = type;
            this.tier = tier;
            this.charges = charges;
            byte maxTier = (byte)(type == -1 ? 12 : (type == 1 ? 4 : 0));
            this.size = tier <= maxTier ? (float)Math.pow(2.0, tier * type) : 1.0f;
            this.maxCharges = (float)Math.pow(2.0, maxTier - tier);
        }

        public boolean showBar() {
            return this.type != 0 && this.charges > 0;
        }

        public double getBar() {
            return (float)this.charges / this.maxCharges;
        }

        public String getChargesLeft() {
            if (this.type == 0) {
                return null;
            }
            return I18n.func_74837_a((String)"item.chiseled_me:recalibrator.charges", (Object[])new Object[]{(int)(this.maxCharges - (float)this.charges)});
        }

        public String getDisplayString(String sub) {
            int s = (int)(this.type == -1 ? 1.0f / this.size : this.size);
            String name = this.type == -1 ? "reduction" : (this.type == 1 ? "amplification" : "reset");
            return I18n.func_74837_a((String)("item.chiseled_me:recalibrator." + name + "." + sub), (Object[])new Object[]{s});
        }

        public ItemStack apply(Entity entity, ItemStack stack) {
            int i;
            boolean isPlayer = entity instanceof EntityPlayer;
            int n = i = isPlayer ? 1 : 2;
            if (this.size != EntitySizeManager.getSize(entity)) {
                if (!entity.field_70170_p.field_72995_K) {
                    EntitySizeManager.setSize(entity, this.size, true);
                    Network.sendSetSizeToClients(entity, this.size, true);
                }
                if (isPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (this.type == -1) {
                        switch (this.tier) {
                            case 1: {
                                player.func_71029_a((StatBase)Achievements.CABLEWORK);
                                break;
                            }
                            case 2: {
                                player.func_71029_a((StatBase)Achievements.BIG_STAIRS);
                                break;
                            }
                            case 3: {
                                player.func_71029_a((StatBase)Achievements.MOUSE_HOLES);
                                break;
                            }
                            case 4: {
                                player.func_71029_a((StatBase)Achievements.C_AND_B_GALORE);
                                break;
                            }
                            case 8: {
                                player.func_71029_a((StatBase)Achievements.C_AND_B_SQUARED);
                                break;
                            }
                            case 9: {
                                player.func_71029_a((StatBase)Achievements.SUPERSMALLS);
                                break;
                            }
                            case 12: {
                                player.func_71029_a((StatBase)Achievements.THE_LIMIT);
                            }
                        }
                    } else if (this.type == 1) {
                        switch (this.tier) {
                            case 1: {
                                player.func_71029_a((StatBase)Achievements.DOUBLE);
                                break;
                            }
                            case 2: {
                                player.func_71029_a((StatBase)Achievements.QUADRUPLE);
                                break;
                            }
                            case 3: {
                                player.func_71029_a((StatBase)Achievements.OCTUPLE);
                                break;
                            }
                            case 4: {
                                player.func_71029_a((StatBase)Achievements.SEXDECUPLE);
                            }
                        }
                    }
                }
            } else {
                i *= 4;
            }
            if (this.type == 0) {
                return stack;
            }
            if ((float)this.charges < this.maxCharges - (float)i) {
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                }
                nbt.func_74768_a("charges", this.charges + i);
                stack.func_77982_d(nbt);
            } else {
                stack.func_77982_d(null);
                if (isPlayer) {
                    ((EntityPlayer)entity).func_71029_a((StatBase)Achievements.RESET);
                }
            }
            return stack;
        }
    }
}

