/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm;

import dev.necauqua.mods.cm.Achievements;
import dev.necauqua.mods.cm.Config;
import dev.necauqua.mods.cm.EntitySizeManager;
import dev.necauqua.mods.cm.Handlers;
import dev.necauqua.mods.cm.Log;
import dev.necauqua.mods.cm.Network;
import dev.necauqua.mods.cm.Recipes;
import dev.necauqua.mods.cm.SizeofCommand;
import dev.necauqua.mods.cm.Utils;
import dev.necauqua.mods.cm.api.ChiseledMeAPI;
import dev.necauqua.mods.cm.api.ChiseledMeInterface;
import dev.necauqua.mods.cm.asm.dsl.ASM;
import dev.necauqua.mods.cm.item.CraftItem;
import dev.necauqua.mods.cm.item.ItemMod;
import dev.necauqua.mods.cm.item.ItemRecalibrator;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@Mod(modid="chiseled_me", version="1.1.5-final", acceptedMinecraftVersions="[1.11,1.11.2]", updateJSON="https://raw.githubusercontent.com/necauqua/chiseled-me/master/updates.json", certificateFingerprint="c677c954974252994736eb15e855e1e6fc5a2e62", useMetadata=true)
public final class ChiseledMe
implements ChiseledMeInterface {
    public static final String MODID = "chiseled_me";
    public static final CreativeTabs TAB = new CreativeTabs("chiseled_me"){

        @Nonnull
        public ItemStack func_78016_d() {
            return ItemRecalibrator.create((byte)-1, (byte)1);
        }
    };
    public static final Item BLUE_STAR = new CraftItem("blue_star").bindAchievement(12).setGlowing();
    public static final Item PYM_CONTAINER = new CraftItem("pym_container").bindAchievement(0);
    public static final Item PYM_CONTAINER_X = new CraftItem("pym_container_x").bindAchievement(8).func_77625_d(16);
    public static final Item PYM_ESSENSE = new CraftItem("pym_essense").bindAchievement(1).func_77625_d(42);
    public static final Item PYM_ESSENSE_X = new CraftItem("pym_essense_x").bindAchievement(9).func_77625_d(13);
    public static final Item PYM_ESSENSE_B = new CraftItem("pym_essense_b").bindAchievement(15).func_77625_d(7);
    public static final ItemRecalibrator RECALIBRATOR = new ItemRecalibrator();

    @Mod.EventHandler
    public void preInit(FMLFingerprintViolationEvent e) {
        Log.warn("FINGERPRINT VIOLATED: you're running some unauthorized modification of the mod, be warned");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        ASM.check();
        ChiseledMe.populateApi(this);
        Config.init(e.getModConfigurationDirectory());
        Network.init();
        EntitySizeManager.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        Utils.forEachStaticField(this.getClass(), ItemMod.class, ItemMod::init);
        Handlers.init();
        Achievements.init();
        Recipes.init();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new SizeofCommand());
    }

    @Override
    public float getSizeOf(Entity entity) {
        return (float)EntitySizeManager.getSize(entity);
    }

    @Override
    public float getRenderSizeOf(Entity entity, float partialTick) {
        return (float)EntitySizeManager.getRenderSize(entity, partialTick);
    }

    @Override
    public void setSizeOf(Entity entity, float size, boolean interp) {
        EntitySizeManager.setSizeAndSync(entity, size, interp);
    }

    private static void populateApi(ChiseledMeInterface api) {
        try {
            EnumHelper.setFailsafeFieldValue((Field)ChiseledMeAPI.class.getField("interaction"), null, (Object)api);
        }
        catch (Exception e) {
            throw new AssertionError("This should not happen", e);
        }
    }
}

