/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm;

import dev.necauqua.mods.cm.Network;
import dev.necauqua.mods.cm.api.ISizedEntity;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.IntHashMap;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class EntitySizeManager {
    public static final float LOWER_LIMIT = 2.4414062E-4f;
    public static final float UPPER_LIMIT = 16.0f;
    private static final IntHashMap<SetSize> spawnSetSizeQueue = new IntHashMap();

    private EntitySizeManager() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new EntitySizeManager());
    }

    public static double getSize(Entity entity) {
        return ((ISizedEntity)entity).getEntitySize();
    }

    public static double getRenderSize(Entity entity, float partialTick) {
        return ((ISizedEntity)entity).getEntitySize(partialTick);
    }

    public static void setSize(Entity entity, double size, boolean interpolate) {
        if (size < 2.44140625E-4 || size > 16.0) {
            return;
        }
        entity.func_184210_p();
        entity.func_184226_ay();
        Entity[] parts = entity.func_70021_al();
        if (parts != null) {
            for (Entity part : parts) {
                EntitySizeManager.setSize(part, size, interpolate);
            }
        }
        ((ISizedEntity)entity).setEntitySize(size, interpolate);
    }

    public static void setSizeAndSync(Entity entity, double size, boolean interpolate) {
        EntitySizeManager.setSize(entity, size, interpolate);
        EntitySizeManager.setSizeOnTrackingClients(entity, size, interpolate);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setSizeClient(int entityId, double size, boolean interp) {
        Entity entity = ClientOnly.getEntityById(entityId);
        if (entity != null) {
            EntitySizeManager.setSize(entity, size, interp);
        } else {
            spawnSetSizeQueue.func_76038_a(entityId, (Object)new SetSize(size, interp));
        }
    }

    public static void setSizeOnTrackingClients(Entity entity, double size, boolean interpolate) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity instanceof EntityPlayerMP) {
            Network.setSizeOfClient((EntityPlayerMP)entity, size, interpolate);
        }
        for (EntityPlayer entityPlayer : ((WorldServer)entity.field_70170_p).func_73039_n().getTrackingPlayers(entity)) {
            Network.setSizeOnClient((EntityPlayerMP)entityPlayer, entity.func_145782_y(), size, interpolate);
        }
    }

    private static void trySetSizeFromQueue(int id, Entity entity) {
        SetSize size = (SetSize)spawnSetSizeQueue.func_76049_d(id);
        if (size != null) {
            EntitySizeManager.setSize(entity, size.size, size.interp);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent e) {
        Entity entity = e.getEntity();
        if (entity.field_70170_p.field_72995_K) {
            if (entity instanceof EntityPlayer) {
                EntitySizeManager.trySetSizeFromQueue(-1, entity);
            }
            EntitySizeManager.trySetSizeFromQueue(entity.func_145782_y(), entity);
        } else {
            double size = EntitySizeManager.getSize(entity);
            if (size != 1.0) {
                EntitySizeManager.setSizeOnTrackingClients(entity, size, false);
            }
        }
    }

    @SubscribeEvent
    public void onStartTracking(PlayerEvent.StartTracking e) {
        Entity entity = e.getTarget();
        double size = EntitySizeManager.getSize(entity);
        if (size != 1.0) {
            Network.setSizeOnClient((EntityPlayerMP)e.getEntityPlayer(), entity.func_145782_y(), size, false);
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone e) {
        if (!e.isWasDeath()) {
            EntitySizeManager.setSizeAndSync((Entity)e.getOriginal(), EntitySizeManager.getSize(e.getEntity()), false);
        }
    }

    private static class SetSize {
        private final double size;
        private final boolean interp;

        private SetSize(double size, boolean interp) {
            this.size = size;
            this.interp = interp;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class ClientOnly {
        private ClientOnly() {
        }

        @Nullable
        private static Entity getEntityById(int id) {
            Minecraft mc = Minecraft.func_71410_x();
            if (id == -1) {
                return mc.field_71439_g;
            }
            if (mc.field_71441_e == null) {
                return null;
            }
            return mc.field_71441_e.func_73045_a(id);
        }
    }
}

