/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm;

import dev.necauqua.mods.cm.Config;
import dev.necauqua.mods.cm.EntitySizeManager;
import dev.necauqua.mods.cm.Log;
import java.lang.reflect.Field;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public final class Handlers {
    private static final String NBT_KEY_SIZE = "chiseled_me:size";
    private static final EntityPlayer.SleepResult TOO_SMALL = EnumHelper.addStatus((String)"TOO_SMALL");
    private static final EntityPlayer.SleepResult TOO_BIG = EnumHelper.addStatus((String)"TOO_BIG");

    private Handlers() {
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new Handlers());
        if (Config.changeBedAABB) {
            Handlers.fixBedAABB();
        }
    }

    private static void fixBedAABB() {
        try {
            Field f = ReflectionHelper.findField(BlockBed.class, (String[])new String[]{"field_185513_c", "BED_AABB"});
            AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.1875, 0.0, 1.0, 0.5625, 1.0);
            EnumHelper.setFailsafeFieldValue((Field)f, null, (Object)aabb);
        }
        catch (Exception e) {
            Log.error("Failed to modify bed AABB!", e);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        double size = EntitySizeManager.getSize((Entity)entity);
        if (size == 1.0) {
            return;
        }
        if (size < 1.0 && Config.scaleSmall) {
            event.setDistance((float)((double)event.getDistance() / size));
            return;
        }
        if (size > 1.0 && Config.scaleBig) {
            event.setDistance((float)((double)event.getDistance() / size));
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteractSpecific e) {
        if (EntitySizeManager.getSize(e.getEntity()) != EntitySizeManager.getSize(e.getTarget())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent e) {
        if (e.isMounting() && (EntitySizeManager.getSize(e.getEntityMounting()) != 1.0 || EntitySizeManager.getSize(e.getEntityBeingMounted()) != 1.0)) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent e) {
        EntityPlayer player = e.getEntityPlayer();
        double size = EntitySizeManager.getSize((Entity)player);
        if (size < 1.0) {
            e.setResult(TOO_SMALL);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chiseled_me.bed.too_small", new Object[0]));
        } else if (size > 1.0) {
            e.setResult(TOO_BIG);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chiseled_me.bed.too_big", new Object[0]));
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent e) {
        double size = EntitySizeManager.getSize(e.getEntity());
        if (size != 1.0) {
            for (EntityItem item : e.getDrops()) {
                EntitySizeManager.setSize((Entity)item, size, false);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDrop(ItemTossEvent e) {
        double size = EntitySizeManager.getSize((Entity)e.getPlayer());
        if (size != 1.0) {
            EntitySizeManager.setSize((Entity)e.getEntityItem(), size, false);
        }
    }

    @SubscribeEvent
    public void onPlayerBreak(BlockEvent.HarvestDropsEvent e) {
        EntityPlayer player = e.getHarvester();
        if (player != null) {
            double d;
            double size = EntitySizeManager.getSize((Entity)player);
            if (d < 1.0) {
                for (ItemStack stack : e.getDrops()) {
                    NBTTagCompound nbt = stack.func_77978_p();
                    if (nbt == null) {
                        nbt = new NBTTagCompound();
                    }
                    nbt.func_74780_a(NBT_KEY_SIZE, size);
                    stack.func_77982_d(nbt);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent e) {
        double size;
        EntityLivingBase thrower;
        Entity entity = e.getEntity();
        if (entity instanceof EntityItem) {
            ItemStack stack = ((EntityItem)entity).func_92059_d();
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null && nbt.func_150297_b(NBT_KEY_SIZE, 6)) {
                EntitySizeManager.setSize(entity, nbt.func_74769_h(NBT_KEY_SIZE), false);
                nbt.func_82580_o(NBT_KEY_SIZE);
                if (nbt.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            }
            return;
        }
        if (entity instanceof EntityThrowable) {
            thrower = ((EntityThrowable)entity).func_85052_h();
        } else if (entity instanceof EntityArrow) {
            thrower = ((EntityArrow)entity).field_70250_c;
        } else if (entity instanceof IThrowableEntity) {
            thrower = ((IThrowableEntity)entity).getThrower();
        } else {
            return;
        }
        if (thrower != null && (size = EntitySizeManager.getSize((Entity)thrower)) != 1.0) {
            EntitySizeManager.setSize(entity, size, false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerBreakSpeed(PlayerEvent.BreakSpeed e) {
        e.setNewSpeed((float)((double)e.getNewSpeed() * EntitySizeManager.getSize(e.getEntity())));
    }
}

