/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm;

import dev.necauqua.mods.cm.EntitySizeManager;
import dev.necauqua.mods.cm.Log;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class Network {
    private static FMLEventChannel channel;

    private Network() {
    }

    public static void init() {
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("chiseled_me");
        channel.register((Object)new Network());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientReceive(FMLNetworkEvent.ClientCustomPacketEvent e) {
        PacketBuffer payload = new PacketBuffer(e.getPacket().payload());
        byte id = payload.readByte();
        switch (id) {
            case 0: {
                EntitySizeManager.setSizeClient(payload.readInt(), payload.readDouble(), payload.readBoolean());
                break;
            }
            case 1: {
                EntitySizeManager.setSizeClient(-1, payload.readDouble(), payload.readBoolean());
                break;
            }
            default: {
                Network.invalidPacket(id, payload);
            }
        }
    }

    public static void setSizeOnClient(EntityPlayerMP client, int entityId, double size, boolean interpolate) {
        channel.sendTo(Network.packet(0, p -> {
            p.writeInt(entityId);
            p.writeDouble(size);
            p.writeBoolean(interpolate);
        }), client);
    }

    public static void setSizeOfClient(EntityPlayerMP client, double size, boolean interpolate) {
        channel.sendTo(Network.packet(1, p -> {
            p.writeDouble(size);
            p.writeBoolean(interpolate);
        }), client);
    }

    private static FMLProxyPacket packet(int id, Consumer<PacketBuffer> data) {
        PacketBuffer payload = new PacketBuffer(Unpooled.buffer());
        payload.writeByte(id);
        data.accept(payload);
        return new FMLProxyPacket(payload, "chiseled_me");
    }

    private static void invalidPacket(byte id, PacketBuffer payload) {
        StringBuilder out = new StringBuilder("Invalid packet received, its content was: ").append(id);
        int i = -1;
        while (payload.isReadable() && i++ < 16) {
            byte b = payload.readByte();
            String hex = Integer.toHexString(b);
            out.append(", ");
            if (hex.length() < 2) {
                out.append('0');
            }
            out.append(hex);
        }
        if (payload.isReadable()) {
            out.append("and ").append(payload.readableBytes()).append(" bytes more...");
        }
        Log.error(out);
    }
}

