/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm;

import dev.necauqua.mods.cm.Achievements;
import dev.necauqua.mods.cm.ChiseledMe;
import dev.necauqua.mods.cm.Config;
import dev.necauqua.mods.cm.item.ItemRecalibrator;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatBase;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;

public final class Recipes {
    private Recipes() {
    }

    public static void init() {
        int j;
        Object[] params;
        int i;
        OreDictionary.registerOre((String)"netherStar", (Item)ChiseledMe.BLUE_STAR);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(ChiseledMe.BLUE_STAR), (Object[])new Object[]{Items.field_151156_bN, Blocks.field_150368_y});
        GameRegistry.addRecipe((IRecipe)new BlueStarDecraftRecipe());
        RecipeSorter.register((String)"chiseled_me:blue_star_decraft", BlueStarDecraftRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        GameRegistry.addRecipe((IRecipe)new OverridenBeaconRecipe());
        RecipeSorter.register((String)"chiseled_me:overriden_beacon", OverridenBeaconRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped before:forge:shapedore");
        GameRegistry.addRecipe((IRecipe)new PymContainerRecipe());
        RecipeSorter.register((String)"chiseled_me:container", PymContainerRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped before:minecraft:shapeless");
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(ChiseledMe.PYM_ESSENSE), (Object[])new Object[]{ChiseledMe.PYM_CONTAINER, Blocks.field_150451_bX, Blocks.field_150451_bX, Blocks.field_150451_bX, Blocks.field_150451_bX, Blocks.field_150451_bX, Blocks.field_150451_bX, Blocks.field_150451_bX, Blocks.field_150451_bX});
        for (i = 1; i <= 8; ++i) {
            params = new Object[i + 1];
            params[0] = Items.field_185157_bK;
            for (j = 1; j <= i; ++j) {
                params[j] = ChiseledMe.PYM_ESSENSE;
            }
            GameRegistry.addShapelessRecipe((ItemStack)ItemRecalibrator.create((byte)-1, (byte)i), (Object[])params);
        }
        if (Config.enableSupersmalls || Config.enableBigSizes) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ChiseledMe.PYM_CONTAINER_X), (Object[])new Object[]{"xyx", "yzy", "xyx", Character.valueOf('x'), Blocks.field_150339_S, Character.valueOf('y'), Blocks.field_150484_ah, Character.valueOf('z'), ChiseledMe.PYM_CONTAINER});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(ChiseledMe.PYM_ESSENSE_X), (Object[])new Object[]{ChiseledMe.PYM_CONTAINER_X, Items.field_151156_bN, Blocks.field_150451_bX});
        }
        if (Config.enableSupersmalls) {
            for (i = 1; i <= 4; ++i) {
                params = new Object[i + 1];
                params[0] = Items.field_185157_bK;
                for (j = 1; j <= i; ++j) {
                    params[j] = ChiseledMe.PYM_ESSENSE_X;
                }
                GameRegistry.addShapelessRecipe((ItemStack)ItemRecalibrator.create((byte)-1, (byte)(i + 8)), (Object[])params);
            }
        }
        if (Config.enableBigSizes) {
            GameRegistry.addRecipe((IRecipe)new BlueEssenseRecipe());
            RecipeSorter.register((String)"chiseled_me:blue_essense", BlueEssenseRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            for (i = 1; i <= 4; ++i) {
                params = new Object[i + 1];
                params[0] = Items.field_185157_bK;
                for (j = 1; j <= i; ++j) {
                    params[j] = ChiseledMe.PYM_ESSENSE_B;
                }
                GameRegistry.addShapelessRecipe((ItemStack)ItemRecalibrator.create((byte)1, (byte)i), (Object[])params);
            }
        }
    }

    private static class BlueStarDecraftRecipe
    implements IRecipe {
        private BlueStarDecraftRecipe() {
        }

        public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
            boolean once = false;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_77973_b() == ChiseledMe.BLUE_STAR) {
                    once = true;
                    continue;
                }
                if (stack.func_190926_b()) continue;
                return false;
            }
            return once;
        }

        @Nonnull
        public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
            long count = IntStream.range(0, inv.func_70302_i_()).filter(i -> !inv.func_70301_a(i).func_190926_b()).count();
            return new ItemStack(Blocks.field_150368_y, (int)count);
        }

        public int func_77570_a() {
            return 9;
        }

        @Nonnull
        public ItemStack func_77571_b() {
            return new ItemStack(Blocks.field_150368_y);
        }

        @Nonnull
        public NonNullList<ItemStack> func_179532_b(@Nonnull InventoryCrafting inv) {
            NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
            IntStream.range(0, inv.func_70302_i_()).filter(i -> inv.func_70301_a(i).func_77973_b() == ChiseledMe.BLUE_STAR).forEach(i -> {
                ItemStack cfr_ignored_0 = (ItemStack)ret.set(i, (Object)new ItemStack(Items.field_151156_bN));
            });
            ForgeHooks.getCraftingPlayer().func_71029_a((StatBase)Achievements.SURPRISE);
            return ret;
        }
    }

    private static class BlueEssenseRecipe
    extends ShapelessRecipes {
        private BlueEssenseRecipe() {
            super(new ItemStack(ChiseledMe.PYM_ESSENSE_B), Arrays.asList(new ItemStack(ChiseledMe.PYM_ESSENSE_X), new ItemStack(ChiseledMe.BLUE_STAR)));
        }

        @Nonnull
        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            NonNullList remaining = super.func_179532_b(inv);
            IntStream.range(0, inv.func_70302_i_()).filter(i -> inv.func_70301_a(i).func_77973_b() == ChiseledMe.BLUE_STAR).forEach(i -> {
                ItemStack cfr_ignored_0 = (ItemStack)remaining.set(i, (Object)new ItemStack(Items.field_151156_bN));
            });
            return remaining;
        }
    }

    private static class PymContainerRecipe
    extends ShapedRecipes {
        private static PotionType awkward = PotionType.func_185168_a((String)"minecraft:awkward");

        private PymContainerRecipe() {
            super(3, 3, new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151045_i), new ItemStack((Item)Items.field_151068_bn), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151042_j)}, new ItemStack(ChiseledMe.PYM_CONTAINER));
        }

        public boolean func_77569_a(@Nonnull InventoryCrafting inv, World world) {
            if (super.func_77569_a(inv, world)) {
                ItemStack stack = inv.func_70301_a(4);
                return PotionUtils.func_185191_c((ItemStack)stack) == awkward;
            }
            return false;
        }
    }

    private static class OverridenBeaconRecipe
    extends ShapedRecipes {
        public OverridenBeaconRecipe() {
            super(3, 3, new ItemStack[]{new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150359_w), new ItemStack(ChiseledMe.BLUE_STAR), new ItemStack(Blocks.field_150359_w), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z)}, OverridenBeaconRecipe.createBlueBeacon());
        }

        @Nonnull
        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            ForgeHooks.getCraftingPlayer().func_71029_a((StatBase)Achievements.WEIRD_BEACON);
            return super.func_179532_b(inv);
        }

        private static ItemStack createBlueBeacon() {
            ItemStack beacon = new ItemStack((Block)Blocks.field_150461_bJ);
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("chiseled_me:color", (byte)3);
            nbt.func_74782_a("BlockEntityTag", (NBTBase)tag);
            beacon.func_77982_d(nbt);
            return beacon;
        }
    }
}

