/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.asm.dsl;

import dev.necauqua.mods.cm.asm.dsl.ASM;
import dev.necauqua.mods.cm.asm.dsl.ClassPatcherDsl;
import dev.necauqua.mods.cm.asm.dsl.Hook;
import dev.necauqua.mods.cm.asm.dsl.MethodPatcher;
import dev.necauqua.mods.cm.asm.dsl.MethodPatcherDsl;
import java.util.ArrayList;
import java.util.List;

public final class ClassPatcher
implements ClassPatcherDsl {
    private final String className;
    private final List<FieldDesc> fields = new ArrayList<FieldDesc>();
    private final List<MethodDesc> methods = new ArrayList<MethodDesc>();
    private final List<MethodPatcher> methodPatchers = new ArrayList<MethodPatcher>();
    private final List<String> extraInterfaces = new ArrayList<String>();
    private final List<String> strippedInterfaces = new ArrayList<String>();

    public ClassPatcher(String className) {
        this.className = className;
    }

    public List<MethodPatcher> getMethodPatchers() {
        return this.methodPatchers;
    }

    public List<FieldDesc> getFields() {
        return this.fields;
    }

    public List<MethodDesc> getMethods() {
        return this.methods;
    }

    public List<String> getExtraInterfaces() {
        return this.extraInterfaces;
    }

    public List<String> getStrippedInterfaces() {
        return this.strippedInterfaces;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public ClassPatcherDsl addField(int acc, String name, String desc, String sign) {
        this.fields.add(new FieldDesc(acc, name, desc, sign));
        return this;
    }

    @Override
    public ClassPatcherDsl addMethod(int acc, String name, String desc, String sign, String[] exceptions, Hook code) {
        this.methods.add(new MethodDesc(acc, name, desc, sign, exceptions, code));
        return this;
    }

    @Override
    public ClassPatcherDsl addInterface(String iface) {
        this.extraInterfaces.add(iface);
        return this;
    }

    @Override
    public ClassPatcherDsl stripInterface(String iface) {
        this.strippedInterfaces.add(iface);
        return this;
    }

    @Override
    public MethodPatcherDsl patchConstructor(String desc) {
        return this.patchMethod("<init>", desc);
    }

    @Override
    public MethodPatcherDsl patchMethod(String name, String desc) {
        MethodPatcher patch = new MethodPatcher(this, ASM.currentTransformer, name, desc, false);
        this.methodPatchers.add(patch);
        return patch;
    }

    @Override
    public MethodPatcherDsl patchMethodOptionally(String name, String desc) {
        MethodPatcher patch = new MethodPatcher(this, ASM.currentTransformer, name, desc, true);
        this.methodPatchers.add(patch);
        return patch;
    }

    public static final class FieldDesc {
        private final int acc;
        private final String name;
        private final String desc;
        private final String sign;

        public FieldDesc(int acc, String name, String desc, String sign) {
            this.acc = acc;
            this.name = name;
            this.desc = desc;
            this.sign = sign;
        }

        public int getAcc() {
            return this.acc;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getSign() {
            return this.sign;
        }
    }

    public static final class MethodDesc {
        private final int acc;
        private final String name;
        private final String desc;
        private final String sign;
        private final String[] exceptions;
        private final Hook code;

        public MethodDesc(int acc, String name, String desc, String sign, String[] exceptions, Hook code) {
            this.acc = acc;
            this.name = name;
            this.desc = desc;
            this.sign = sign;
            this.exceptions = exceptions;
            this.code = code;
        }

        public int getAcc() {
            return this.acc;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getSign() {
            return this.sign;
        }

        public String[] getExceptions() {
            return this.exceptions;
        }

        public Hook getCode() {
            return this.code;
        }
    }
}

