/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.asm.dsl;

import dev.necauqua.mods.cm.asm.dsl.Hook;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ContextMethodVisitor
extends MethodVisitor {
    private final String className;
    private final Map<String, Integer> locals;
    private final MethodVisitor root;
    private int pass = 1;
    private final int[] currentLineNumber;

    public ContextMethodVisitor(String className, Map<String, Integer> locals, MethodVisitor parent, MethodVisitor root) {
        super(327680, parent);
        this.className = className.replace('.', '/');
        this.locals = locals;
        this.root = root;
        this.currentLineNumber = new int[]{0};
    }

    public ContextMethodVisitor(ContextMethodVisitor mv) {
        super(327680, (MethodVisitor)mv);
        this.className = mv.className;
        this.locals = mv.locals;
        this.root = mv.root;
        this.currentLineNumber = mv.currentLineNumber;
    }

    public void setCurrentLineNumber(int currentLineNumber) {
        this.currentLineNumber[0] = currentLineNumber;
    }

    public int getCurrentLineNumber() {
        return this.currentLineNumber[0];
    }

    public void setPass(int pass) {
        this.pass = pass;
    }

    public int getPass() {
        return this.pass;
    }

    public String getClassName() {
        return this.className;
    }

    public void visitHook(Hook hook) {
        hook.accept(this);
    }

    public void visitFieldInsn(int opcode, String name, String desc) {
        this.visitFieldInsn(opcode, this.className, name, desc);
    }

    public void visitMethodInsn(int opcode, String name, String desc) {
        this.visitMethodInsn(opcode, this.className, name, desc, false);
    }

    private int getLocal(String assocName) {
        Integer var = this.locals.get(assocName);
        if (var == null) {
            throw new IllegalArgumentException("Local with assoc name '" + assocName + "' was never created!");
        }
        return var;
    }

    public void visitVarInsn(int opcode, String assocName) {
        this.root.visitVarInsn(opcode, this.getLocal(assocName));
    }

    public void visitIincInsn(String assocName, int increment) {
        this.root.visitIincInsn(this.getLocal(assocName), increment);
    }

    public void ifJump(int opcode, Runnable body) {
        Label skip = new Label();
        this.visitJumpInsn(opcode, skip);
        body.run();
        this.visitLabel(skip);
    }

    public void ifJump(int opcode, Runnable body, Runnable or) {
        Label then = new Label();
        Label skip = new Label();
        this.visitJumpInsn(opcode, then);
        body.run();
        this.visitJumpInsn(167, skip);
        this.visitLabel(then);
        or.run();
        this.visitLabel(skip);
    }
}

