/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.asm.dsl;

import dev.necauqua.mods.cm.asm.dsl.ClassPatcher;
import dev.necauqua.mods.cm.asm.dsl.ClassPatcherDsl;
import dev.necauqua.mods.cm.asm.dsl.MethodPatcherDsl;
import dev.necauqua.mods.cm.asm.dsl.Patch;
import dev.necauqua.mods.cm.asm.dsl.PatchContextDsl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public final class MethodPatcher
implements MethodPatcherDsl {
    private final ClassPatcher parent;
    private final String transformerName;
    private final boolean optional;
    private int matched = 0;
    private final List<Pair<String, String>> methodsToPatch = new ArrayList<Pair<String, String>>();
    private Patch patch = p -> {};

    public MethodPatcher(ClassPatcher parent, String transformerName, String name, String desc, boolean optional) {
        this.parent = parent;
        this.transformerName = transformerName;
        this.optional = optional;
        this.methodsToPatch.add((Pair<String, String>)Pair.of((Object)name, (Object)desc));
    }

    public ClassPatcher getParent() {
        return this.parent;
    }

    public String getTransformerName() {
        return this.transformerName;
    }

    public List<Pair<String, String>> getMethodsToPatch() {
        return this.methodsToPatch;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean didMatch() {
        return this.matched == this.methodsToPatch.size();
    }

    public void apply(PatchContextDsl context) {
        ++this.matched;
        this.patch.accept(context);
    }

    @Override
    public MethodPatcherDsl and(String name, String desc) {
        this.methodsToPatch.add((Pair<String, String>)Pair.of((Object)name, (Object)desc));
        return this;
    }

    @Override
    public ClassPatcherDsl with(Patch patch) {
        this.patch = patch;
        return this.parent;
    }

    public String getMethodNames() {
        if (this.methodsToPatch.size() == 1) {
            Pair<String, String> method2 = this.methodsToPatch.get(0);
            return (String)method2.getLeft() + (String)method2.getRight();
        }
        return this.methodsToPatch.stream().map(method -> (String)method.getLeft() + (String)method.getRight()).collect(Collectors.joining(", ", "[ ", " ]"));
    }
}

