/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.asm.dsl;

import dev.necauqua.mods.cm.asm.dsl.ContextMethodVisitor;
import dev.necauqua.mods.cm.asm.dsl.Hook;
import dev.necauqua.mods.cm.asm.dsl.MethodPatcher;
import dev.necauqua.mods.cm.asm.dsl.ModifierType;
import dev.necauqua.mods.cm.asm.dsl.anchors.Anchor;

public final class Modifier {
    private final MethodPatcher parent;
    private final ModifierType type;
    private final Anchor anchor;
    private final int index;
    private final Hook hook;
    private boolean matched = false;

    public Modifier(MethodPatcher parent, Anchor anchor, Hook hook, ModifierType type, int index) {
        this.parent = parent;
        this.type = type;
        this.anchor = anchor;
        this.index = index;
        this.hook = hook;
    }

    public MethodPatcher getParent() {
        return this.parent;
    }

    public ModifierType getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public Hook getHook() {
        return this.hook;
    }

    public boolean didMatch() {
        return this.matched;
    }

    public ContextMethodVisitor apply(ContextMethodVisitor parent) {
        return this.anchor.apply(parent, this);
    }

    public boolean match(ContextMethodVisitor context, int pass) {
        if (this.index != 0 && this.index != pass) {
            return false;
        }
        this.matched = true;
        context.setPass(pass);
        this.hook.accept(context);
        context.setPass(1);
        return true;
    }

    public String toString() {
        return "<" + (Object)((Object)this.type) + (this.index == 0 ? " all" : "") + " " + this.anchor + (this.index > 1 ? " at " + this.index : "") + ">";
    }
}

