/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.asm.dsl;

import dev.necauqua.mods.cm.asm.dsl.Hook;
import dev.necauqua.mods.cm.asm.dsl.MethodPatcher;
import dev.necauqua.mods.cm.asm.dsl.Modifier;
import dev.necauqua.mods.cm.asm.dsl.ModifierType;
import dev.necauqua.mods.cm.asm.dsl.PatchContextDsl;
import dev.necauqua.mods.cm.asm.dsl.anchors.Anchor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.Type;

public final class PatchContext
implements PatchContextDsl {
    private final List<Modifier> modifiers = new ArrayList<Modifier>();
    private final List<Pair<String, Type>> locals = new ArrayList<Pair<String, Type>>();
    private final MethodPatcher parent;
    private boolean dump = false;

    PatchContext(MethodPatcher parent) {
        this.parent = parent;
    }

    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    public List<Pair<String, Type>> getLocals() {
        return this.locals;
    }

    public boolean isDump() {
        return this.dump;
    }

    @Override
    public void addLocal(String name, Type type) {
        this.locals.add((Pair<String, Type>)Pair.of((Object)name, (Object)type));
    }

    @Override
    public void modify(ModifierType type, Anchor anchor, int nth, Hook hook) {
        this.modifiers.add(new Modifier(this.parent, anchor, hook, type, nth));
    }

    @Override
    public void debugDump() {
        this.dump = true;
    }

    @Override
    public String getClassName() {
        return this.parent.getParent().getClassName();
    }
}

