/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cm.size;

public final class ChangingSizeProcess {
    private static final double TWO_OVER_LOG_TWO = 2.0 / Math.log(2.0);
    public final double fromSize;
    public final double toSize;
    public double prevTickSize;
    public int interpTicks;
    public int interpInterval;

    public ChangingSizeProcess(double fromSize, double toSize) {
        this.fromSize = fromSize;
        this.toSize = toSize;
        this.prevTickSize = fromSize;
        this.interpTicks = 0;
        this.interpInterval = ChangingSizeProcess.calculateInterpolationInterval(fromSize, toSize);
    }

    public String toString() {
        return "ChangingSizeProcess{fromSize=" + this.fromSize + ", toSize=" + this.toSize + '}';
    }

    public static int calculateInterpolationInterval(double fromSize, double toSize) {
        return (int)(Math.abs(Math.log(fromSize) - Math.log(toSize)) * TWO_OVER_LOG_TWO);
    }
}

