/*
 * Decompiled with CFR 0.152.
 */
package net.ipixeli.gender.client;

import java.util.ArrayList;
import net.ipixeli.gender.client.FlatListClient;
import net.ipixeli.gender.client.GenderClient;
import net.ipixeli.gender.client.ManagerTempObject;
import net.ipixeli.gender.client.ObjectPlayerClient;
import net.ipixeli.gender.client.ObjectPlayerTemp;
import net.ipixeli.gender.common.Gender;
import net.ipixeli.gender.common.SpecialFew;

public class ManagerPlayerClient {
    public static ManagerPlayerClient instance;
    private FlatListClient listClient;
    protected static ArrayList<ObjectPlayerClient> clientGPOs;

    public ManagerPlayerClient() {
        instance = this;
    }

    public void loadClientList() {
        this.listClient = new FlatListClient(Gender.instance.getDir(), "genderlistclient.txt");
        this.listClient.loadList();
    }

    private ObjectPlayerClient createDefaultObject(String s) {
        ObjectPlayerClient opc = new ObjectPlayerClient(s, false, false, 2);
        this.registerOPCClient(opc);
        return opc;
    }

    public void registerOPCClient(ObjectPlayerClient opc) {
        if (this.get(opc.getUsername()) == null) {
            clientGPOs.add(opc);
        }
    }

    public ObjectPlayerClient get(String s) {
        for (ObjectPlayerClient p : clientGPOs) {
            if (!s.equals(p.getUsername())) continue;
            return p;
        }
        return null;
    }

    public void rmUserByInt(int current) {
        ObjectPlayerClient p = this.getByInt(current);
        if (SpecialFew.hasHardCode(p.getUsername()) || GenderClient.me.equals(p)) {
            return;
        }
        clientGPOs.remove(current);
    }

    public void toggleGender(int current) {
        ObjectPlayerClient p = this.getByInt(current);
        p = clientGPOs.get(current);
        if (!SpecialFew.hasHardCodedGender(p.getUsername())) {
            p.toggleClientGender();
            this.listClient.saveList();
        }
    }

    public void toggleAge(int current) {
        ObjectPlayerClient p = this.getByInt(current);
        p = clientGPOs.get(current);
        if (!SpecialFew.hasHardCodedAge(p.getUsername())) {
            p.toggleClientAge();
            this.listClient.saveList();
        }
    }

    public boolean isClientFemale(String s) {
        ObjectPlayerClient opc = this.getOrCreate(s);
        if (!GenderClient.config.isEnablePlayerGenders()) {
            return false;
        }
        if (opc.hasHardCode() && SpecialFew.hasHardCodedGender(opc.getUsername())) {
            return SpecialFew.isHardCodedFemale(opc.getUsername());
        }
        return opc.isClientFemale() || opc.isClientFemale();
    }

    public boolean isClientChild(String s) {
        ObjectPlayerClient opc = this.getOrCreate(s);
        if (!GenderClient.config.isPlayerChildrenEnabled()) {
            return false;
        }
        if (opc.hasHardCode() && SpecialFew.hasHardCodedAge(opc.getUsername())) {
            return SpecialFew.isHardCodedChild(opc.getUsername());
        }
        return opc.isClientChild() || opc.isClientChild();
    }

    public ObjectPlayerClient getOrCreate(String s) {
        ObjectPlayerClient p = this.get(s);
        if (p == null) {
            p = this.createDefaultObject(s);
        }
        return p;
    }

    public void addUser(String s) {
        if (this.get(s) == null) {
            this.createDefaultObject(s);
        }
        this.listClient.saveList();
    }

    public ArrayList<ObjectPlayerClient> getListClient() {
        return clientGPOs;
    }

    public ObjectPlayerClient getByInt(int current) {
        return clientGPOs.get(current);
    }

    public boolean[] getShownValues(String s) {
        ObjectPlayerClient user = instance.get(s);
        boolean f = false;
        boolean c = false;
        if (user == null) {
            ObjectPlayerTemp gto = ManagerTempObject.getObjectTmp(s);
            if (gto != null) {
                f = GenderClient.config.enablePlayerGenders ? gto.isFemale() : false;
                c = GenderClient.config.enablePlayerChildren ? gto.isChild() : false;
            }
        } else {
            f = this.getIsShownFemale(user);
            c = this.getIsShownChild(user);
        }
        return new boolean[]{f, c};
    }

    private boolean getWhoWins(int priority, boolean client, boolean tmp) {
        switch (priority) {
            case 0: {
                return client;
            }
            case 1: {
                return client || tmp;
            }
            case 2: {
                return tmp;
            }
        }
        return false;
    }

    private int getWhoWins(int priority, int client, int tmp) {
        switch (priority) {
            case 0: {
                return client;
            }
            case 1: {
                return client > tmp ? client : tmp;
            }
            case 2: {
                return tmp;
            }
        }
        return 2;
    }

    private boolean getIsShownFemale(ObjectPlayerClient o) {
        if (!GenderClient.config.isEnablePlayerGenders()) {
            return false;
        }
        if (o.hasHardCode() && SpecialFew.hasHardCodedGender(o.getUsername())) {
            return SpecialFew.isHardCodedFemale(o.getUsername());
        }
        ObjectPlayerTemp tmp = ManagerTempObject.getObjectTmp(o.getUsername());
        if (tmp == null) {
            return o.isClientFemale();
        }
        return this.getWhoWins(GenderClient.config.priorityMode(), o.isClientFemale(), tmp.isFemale());
    }

    private boolean getIsShownChild(ObjectPlayerClient o) {
        if (!GenderClient.config.enablePlayerChildren) {
            return false;
        }
        if (o.hasHardCode() && SpecialFew.hasHardCodedAge(o.getUsername())) {
            return SpecialFew.isHardCodedChild(o.getUsername());
        }
        ObjectPlayerTemp tmp = ManagerTempObject.getObjectTmp(o.getUsername());
        if (tmp == null) {
            return o.isClientChild();
        }
        return this.getWhoWins(GenderClient.config.priorityMode(), o.isClientChild(), tmp.isChild());
    }

    public int getShownModel(String s) {
        return GenderClient.config.settingPlayerModel;
    }

    public boolean hasSkin(String s) {
        ObjectPlayerClient opc = this.get(s);
        return opc != null ? opc.hasSkin : false;
    }

    public boolean hasEntry(String s) {
        return this.get(s) != null;
    }

    static {
        clientGPOs = new ArrayList();
    }
}

