/*
 * Decompiled with CFR 0.152.
 */
package net.ipixeli.gender.server;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.util.Arrays;
import net.ipixeli.gender.common.Gender;
import net.ipixeli.gender.server.ManagerPlayerServer;
import net.ipixeli.gender.server.ObjectPlayerCommon;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumChatFormatting;

public class GenderServer {
    public static final String prefix = "[GenderServer] ";
    public static final String prefixChat = "[" + EnumChatFormatting.LIGHT_PURPLE + "Gender" + EnumChatFormatting.WHITE + "] ";
    protected static MinecraftServer server;
    private static File dir;

    public GenderServer() {
        System.out.println(prefix + this.getClass().getSimpleName() + " init!");
        dir = Gender.instance.getDir();
        server = MinecraftServer.func_71276_C();
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    protected static String getFemalesToSendChat() {
        String names = "";
        for (ObjectPlayerCommon o : ManagerPlayerServer.instance.getListServer()) {
            if (!Arrays.asList(server.func_71203_ab().func_72369_d()).contains(o.getUsername())) continue;
            names = names.concat(o.getUsername() + ":" + (o.getIsServerFemale() ? "F" : "M") + ":" + (o.getIsServerChild() ? "C" : "A") + ":" + o.getServerModel()) + ";";
        }
        if (Gender.modedebug) {
            System.out.println(prefix + (names.length() > 2 ? names : "none"));
        }
        return names;
    }

    protected static String getFemalesToSendPacket() {
        return GenderServer.getFemalesToSendChat().replaceAll(", ", ":").toString();
    }

    public static void sendPacketBroadCastSync() {
        Gender.packetHandler.sendToAll(GenderServer.getPacket());
    }

    public static void sendListToPlayer(EntityPlayerMP player) {
        Gender.packetHandler.sendTo(GenderServer.getPacket(), player);
    }

    private static FMLProxyPacket getPacket() {
        byte[] b = GenderServer.getFemalesToSendPacket().getBytes();
        ByteBuf payload = Unpooled.buffer();
        payload.writeInt(b.length);
        payload.writeBytes(b);
        return new FMLProxyPacket(payload, "Gender");
    }

    @SubscribeEvent
    @SideOnly(value=Side.SERVER)
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        GenderServer.sendPacketBroadCastSync();
    }
}

