/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge.client;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.Log;
import com.github.ipixeli.gender.core.client.Logic;
import com.github.ipixeli.gender.core.client.events.PlayerScale;
import com.github.ipixeli.gender.core.client.events.PlayerTexture;
import com.github.ipixeli.gender.core.client.events.ZombieTexture;
import com.github.ipixeli.gender.core.options.EnumAge;
import com.github.ipixeli.gender.core.options.EnumGender;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import com.github.ipixeli.gender.forge.Datagram;
import com.github.ipixeli.gender.forge.GenderForge;
import com.github.ipixeli.gender.forge.client.Accessor;
import com.github.ipixeli.gender.forge.client.Events;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlclient.registry.ClientRegistry;

public class GenderClient {
    public static boolean corePlayerScale = false;
    public static boolean corePlayerTexture = false;
    public static boolean coreZombieTexture = false;
    public static final KeyMapping key = new KeyMapping("key.gender.menu", 71, "iPixeli's Gender Mod");
    public static boolean regLayers = false;

    public static void onStartup(File modDir, Log log, Minecraft mc) {
        ClientRegistry.registerKeyBinding((KeyMapping)key);
        Gender.onClientStartup(modDir, log, new Accessor(mc, log));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(Events::register);
    }

    public static void sendProfilePacket(PlayerProfile p) {
        GenderForge.channel.sendToServer((Object)new Datagram(p));
    }

    public static void onEvent(AbstractClientPlayer p, PoseStack poseStack) {
        if (!corePlayerScale) {
            corePlayerScale = true;
        }
        Accessor mca = Accessor.instance();
        float dist = mca.getSelfEntity().m_20270_((Entity)p);
        float scale = PlayerScale.get(mca, mca.getName(p), mca.getUUID(p), mca.isSelf(p), dist, p.m_20185_(), p.m_20186_(), p.m_20189_(), p.m_20205_(), p.m_20206_());
        poseStack.m_85841_(scale, scale, scale);
    }

    public static ResourceLocation onEvent(UUID uuid) {
        if (!corePlayerTexture) {
            corePlayerTexture = true;
        }
        Accessor mca = Accessor.instance();
        String name = mca.getNameFromUuid(uuid);
        String uuidStr = uuid.toString();
        EnumAge a = Logic.getVisibleAge(name, uuidStr, false, false);
        EnumGender g = Logic.getVisibleGender(name, uuidStr, false, false);
        ResourceLocation texture = (ResourceLocation)PlayerTexture.get(mca, uuidStr, a, g);
        return texture;
    }

    public static ResourceLocation onEvent(Zombie z) {
        if (!coreZombieTexture) {
            coreZombieTexture = true;
        }
        int eid = z.m_142049_();
        boolean isChild = z.m_6162_();
        ResourceLocation texture = (ResourceLocation)ZombieTexture.get(eid, isChild);
        return texture;
    }
}

