/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge.client.gui;

import com.github.ipixeli.gender.core.profiles.BaseListMgr;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import com.github.ipixeli.gender.forge.client.gui.ListScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;

public final class ListWidget
extends ObjectSelectionList<ProfileEntry> {
    private final int listWidth;
    private ListScreen parent;
    private BaseListMgr manager;
    private Font font;

    public ListWidget(ListScreen parent, Font fontIn, BaseListMgr managerIn, int listWidthIn, int top, int itemHeight) {
        Minecraft minecraft = parent.getMinecraft();
        int n = parent.f_96544_;
        Objects.requireNonNull(fontIn);
        super(minecraft, listWidthIn, n, top, itemHeight, 9 + 4);
        this.parent = parent;
        this.manager = managerIn;
        this.listWidth = listWidthIn;
        this.font = fontIn;
        this.m_93507_(parent.boundLeft);
        this.f_93390_ = parent.boundTop;
        this.f_93393_ = parent.boundLeft;
        this.f_93392_ = parent.boundRight;
        this.f_93391_ = parent.boundBottom;
        this.refreshList();
    }

    public int m_5759_() {
        return this.listWidth;
    }

    protected int m_5756_() {
        return this.listWidth;
    }

    public void refreshList() {
        this.m_93516_();
        for (PlayerProfile p : this.manager.getList()) {
            this.m_7085_((AbstractSelectionList.Entry)new ProfileEntry(p, this.parent, this.font));
        }
    }

    public void m_6305_(PoseStack poseStack, int p_93448_, int p_93449_, float p_93450_) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172820_);
        int i = this.m_5756_();
        int j = i + 6;
        int drawX = this.m_5747_();
        int drawY = this.f_93390_ + 4 - (int)this.m_93517_();
        this.m_93451_(poseStack, drawX, drawY, p_93448_, p_93449_, p_93450_);
        int k1 = this.m_93518_();
        if (k1 > 0) {
            RenderSystem.m_69472_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            int l1 = (int)((float)((this.f_93391_ - this.f_93390_) * (this.f_93391_ - this.f_93390_)) / (float)this.m_5775_());
            l1 = Mth.m_14045_((int)l1, (int)32, (int)(this.f_93391_ - this.f_93390_ - 8));
            int i2 = (int)this.m_93517_() * (this.f_93391_ - this.f_93390_ - l1) / k1 + this.f_93390_;
            if (i2 < this.f_93390_) {
                i2 = this.f_93390_;
            }
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            bufferbuilder.m_5483_((double)i, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)j, (double)this.f_93391_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)j, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)i, (double)this.f_93390_, 0.0).m_6122_(0, 0, 0, 255).m_5752_();
            bufferbuilder.m_5483_((double)i, (double)(i2 + l1), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferbuilder.m_5483_((double)j, (double)(i2 + l1), 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferbuilder.m_5483_((double)j, (double)i2, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferbuilder.m_5483_((double)i, (double)i2, 0.0).m_6122_(128, 128, 128, 255).m_5752_();
            bufferbuilder.m_5483_((double)i, (double)(i2 + l1 - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            bufferbuilder.m_5483_((double)(j - 1), (double)(i2 + l1 - 1), 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            bufferbuilder.m_5483_((double)(j - 1), (double)i2, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            bufferbuilder.m_5483_((double)i, (double)i2, 0.0).m_6122_(192, 192, 192, 255).m_5752_();
            tesselator.m_85914_();
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
    }

    protected void m_93451_(PoseStack poseStack, int p_93453_, int p_93454_, int mouseX, int mouseY, float partialTicks) {
        for (int rowNumber = 0; rowNumber < this.m_5773_(); ++rowNumber) {
            int rowTop = this.m_7610_(rowNumber);
            int rowBottom = rowTop + rowNumber * this.f_93387_;
            if (rowBottom < this.f_93390_ || rowTop > this.f_93391_) continue;
            int rowWidth = this.m_5759_();
            int rowLeft = this.m_5747_();
            int rowHeight = this.f_93387_;
            ProfileEntry e = (ProfileEntry)this.m_93500_(rowNumber);
            e.m_6311_(poseStack, rowNumber, rowTop, rowLeft, rowWidth, rowHeight, mouseX, mouseY, Objects.equals((Object)this.parent.selected, (Object)e), partialTicks);
        }
    }

    public class ProfileEntry
    extends ObjectSelectionList.Entry<ProfileEntry> {
        private final PlayerProfile profile;
        private final ListScreen parent;
        private Font font;

        public ProfileEntry(PlayerProfile info, ListScreen parent, Font fontIn) {
            this.profile = info;
            this.parent = parent;
            this.font = fontIn;
        }

        public Component m_142172_() {
            return new TranslatableComponent("narrator.select", new Object[]{this.profile.name() + " has settings: " + this.profile.getAge().getRenderName() + " " + this.profile.getGender().getRenderName() + " " + this.profile.getModel().getRenderName()});
        }

        public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.parent.setSelected(this);
            ListWidget.this.m_6987_((AbstractSelectionList.Entry)this);
            return false;
        }

        public PlayerProfile profile() {
            return this.profile;
        }

        public void m_6311_(PoseStack poseStack, int rowNumber, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isHovered, float partialTicks) {
            if (ListWidget.this.m_7987_(rowNumber)) {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)rowLeft, (int)(rowTop - 1), (int)(rowLeft + rowWidth), (int)(rowTop + rowHeight), (int)-1429418804);
                GuiComponent.m_93172_((PoseStack)poseStack, (int)(rowLeft + 1), (int)rowTop, (int)(rowLeft - 1 + rowWidth), (int)(rowTop - 1 + rowHeight), (int)-872415232);
            }
            int color = ListWidget.this.manager.getList().contains(this.profile) ? -1 : -7829368;
            Object s = "";
            s = this.profile.name();
            this.font.m_92750_(poseStack, (String)s, (float)(rowLeft += 2), (float)(rowTop += 2), color);
            s = "[" + this.profile.getAge().toString().toLowerCase() + "]";
            this.font.m_92883_(poseStack, (String)s, (float)(rowLeft += this.font.m_92895_("@@@@@@@@@@@@@@@@ ")), (float)rowTop, color);
            rowLeft += this.font.m_92895_((String)s + "  ");
            s = "[" + this.profile.getGender().toString().toLowerCase() + "]";
            this.font.m_92883_(poseStack, (String)s, (float)rowLeft, (float)rowTop, color);
            rowLeft += this.font.m_92895_((String)s + "  ");
            s = "[" + this.profile.getModel().toString().toLowerCase() + "]";
            this.font.m_92883_(poseStack, (String)s, (float)rowLeft, (float)rowTop, color);
            rowLeft += this.font.m_92895_((String)s + "  ");
        }
    }
}

