/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.core.client.assets;

import com.github.ipixeli.gender.core.client.Client;
import com.github.ipixeli.gender.core.client.assets.Asset;
import com.github.ipixeli.gender.core.client.assets.Point;
import com.github.ipixeli.gender.core.options.EnumAge;
import com.github.ipixeli.gender.core.options.EnumGender;
import java.util.ArrayList;

public final class Assets {
    public static final Asset<String, Object> HURT_PLAYER_FEMALE_ADULT = Assets.build("gender:hurt_female_adult");
    public static final Asset<String, Object> HURT_PLAYER_FEMALE_CHILD = Assets.build("gender:hurt_female_child");
    public static final Asset<String, Object> HURT_PLAYER_MALE_ADULT = Assets.build("gender:hurt_male_adult");
    public static final Asset<String, Object> HURT_PLAYER_MALE_CHILD = Assets.build("gender:hurt_male_child");
    public static final Asset<String, Object> HURT_PLAYER_OTHER_ADULT = Assets.build("minecraft:entity.player.hurt");
    public static final Asset<String, Object> HURT_PLAYER_OTHER_CHILD = Assets.build("minecraft:entity.player.hurt");
    public static final ArrayList<Point> model1 = Assets.model1();
    public static final ArrayList<Point> model2 = Assets.model2();
    public static final Asset<String, Object> TEX_GENDER_UI = Assets.build("gender:textures/gui.png");
    public static final Asset<String, Object> TEX_PLAYER_FEMALE_ADULT = Assets.build("gender:textures/entity/player/female_adult.png");
    public static final Asset<String, Object> TEX_PLAYER_FEMALE_CHILD = Assets.build("gender:textures/entity/player/female_child.png");
    public static final Asset<String, Object> TEX_PLAYER_MALE_ADULT = Assets.build("minecraft:textures/entity/steve.png");
    public static final Asset<String, Object> TEX_PLAYER_MALE_CHILD = Assets.build("gender:textures/entity/player/male_child.png");
    public static final Asset<String, Object> TEX_PLAYER_OTHER_ADULT = Assets.build("gender:textures/entity/player/other_adult.png");
    public static final Asset<String, Object> TEX_PLAYER_OTHER_CHILD = Assets.build("gender:textures/entity/player/other_child.png");
    public static final Asset<String, Object> TEX_ZOMBIE_FEMALE_ADULT = Assets.build("gender:textures/entity/zombie/zombie_female_adult.png");
    public static final Asset<String, Object> TEX_ZOMBIE_FEMALE_CHILD = Assets.build("gender:textures/entity/zombie/zombie_female_child.png");
    public static final Asset<String, Object> TEX_ZOMBIE_MALE_ADULT = Assets.build("minecraft:textures/entity/zombie/zombie.png");
    public static final Asset<String, Object> TEX_ZOMBIE_MALE_CHILD = Assets.build("gender:textures/entity/zombie/zombie_male_child.png");

    public static Asset<String, Object> build(String s) {
        return new Asset<String, Object>(s, Client.accessor.getResource(s));
    }

    private static ArrayList<Point> model1() {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(20, 20, -3.0f, 1.0f, -3.0f, 6.0f, 1.0f, 1.0f));
        points.add(new Point(19, 21, -4.0f, 2.0f, -3.0f, 8.0f, 3.0f, 1.0f));
        return points;
    }

    private static ArrayList<Point> model2() {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(20, 20, -3.0f, 1.0f, -3.0f, 6.0f, 1.0f, 1.0f));
        points.add(new Point(19, 21, -4.0f, 2.0f, -3.0f, 8.0f, 3.0f, 1.0f));
        points.add(new Point(20, 21, -3.0f, 2.0f, -4.0f, 6.0f, 1.0f, 1.0f));
        points.add(new Point(19, 22, -4.0f, 3.0f, -4.0f, 8.0f, 1.0f, 1.0f));
        points.add(new Point(20, 23, -3.0f, 4.0f, -4.0f, 2.0f, 1.0f, 1.0f));
        points.add(new Point(23, 23, 1.0f, 4.0f, -4.0f, 2.0f, 1.0f, 1.0f));
        return points;
    }

    public static Asset selectHurt(EnumAge a, EnumGender g) {
        Asset<String, Object> result = null;
        if (g.equals(EnumGender.CUSTOM)) {
            result = a.isChild() ? HURT_PLAYER_OTHER_CHILD : HURT_PLAYER_OTHER_ADULT;
        } else if (g.equals(EnumGender.MALE)) {
            result = a.isChild() ? HURT_PLAYER_MALE_CHILD : HURT_PLAYER_MALE_ADULT;
        } else if (g.equals(EnumGender.FEMALE)) {
            result = a.isChild() ? HURT_PLAYER_FEMALE_CHILD : HURT_PLAYER_FEMALE_ADULT;
        }
        return result;
    }

    public static Asset selectTexturePlayer(EnumAge a, EnumGender g) {
        Asset<String, Object> result = TEX_PLAYER_MALE_ADULT;
        if (g.equals(EnumGender.CUSTOM)) {
            result = a.isChild() ? TEX_PLAYER_OTHER_CHILD : TEX_PLAYER_OTHER_ADULT;
        } else if (g.equals(EnumGender.MALE)) {
            result = a.isChild() ? TEX_PLAYER_MALE_CHILD : TEX_PLAYER_MALE_ADULT;
        } else if (g.equals(EnumGender.FEMALE)) {
            result = a.isChild() ? TEX_PLAYER_FEMALE_CHILD : TEX_PLAYER_FEMALE_ADULT;
        }
        return result;
    }

    public static Asset selectTextureZombie(EnumAge a, EnumGender g) {
        Asset<String, Object> result = TEX_ZOMBIE_MALE_ADULT;
        if (g.equals(EnumGender.MALE)) {
            result = a.isChild() ? TEX_ZOMBIE_MALE_CHILD : TEX_ZOMBIE_MALE_ADULT;
        } else if (g.equals(EnumGender.FEMALE)) {
            result = a.isChild() ? TEX_ZOMBIE_FEMALE_CHILD : TEX_ZOMBIE_FEMALE_ADULT;
        }
        return result;
    }
}

