/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.core.options;

import com.github.ipixeli.gender.core.options.EnumGender;
import com.github.ipixeli.gender.core.options.EnumLifeStage;
import com.github.ipixeli.gender.core.options.Option;
import com.github.ipixeli.gender.core.options.Options;
import java.util.Arrays;
import java.util.List;

public enum EnumModel implements Option
{
    UNSET("", "Unset", EnumLifeStage.NA, Arrays.asList(EnumGender.values())),
    NONE("", "None", EnumLifeStage.NA, Arrays.asList(EnumGender.values())),
    CYNTHIA("", "Cynthia", EnumLifeStage.TEEN, List.of(EnumGender.FEMALE, EnumGender.CUSTOM)),
    STEPHANIE("", "Stephanie", EnumLifeStage.ADULT, List.of(EnumGender.FEMALE, EnumGender.CUSTOM));

    private String symbol;
    private String renderName;
    private EnumLifeStage usableAfter;
    private List<EnumGender> allowedGenders;

    private EnumModel(String s, String r, EnumLifeStage u, List<EnumGender> enumGenders) {
        this.symbol = s;
        this.renderName = r;
        this.usableAfter = u;
        this.allowedGenders = enumGenders;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public String getRenderName() {
        return this.renderName;
    }

    public EnumModel getFromValue(Byte byte1) {
        return Options.listModels.size() > 0 ? Options.listModels.stream().filter(opt -> opt.ordinal() == byte1.byteValue()).findFirst().get() : Options.listModels.get(0);
    }

    public EnumModel next(boolean skipUnset) {
        EnumModel r = UNSET;
        int qty = Options.listModels.size() - 1;
        if (this.ordinal() < qty) {
            r = Options.listModels.get(this.ordinal() + 1);
        }
        if (skipUnset && r.equals(UNSET)) {
            r = Options.listModels.get(1);
        }
        return r;
    }

    public EnumLifeStage getMinimumRequiredStage() {
        return this.usableAfter;
    }

    public List<EnumGender> getAllowedGenders() {
        return this.allowedGenders;
    }
}

