/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.options.EnumAge;
import com.github.ipixeli.gender.core.options.EnumGender;
import com.github.ipixeli.gender.core.options.EnumModel;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import com.github.ipixeli.gender.forge.GenderForge;
import com.github.ipixeli.gender.forge.server.GenderServer;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public final class Datagram {
    private static final Pattern ALLOWED_USERNAME_CHARACTERS = Pattern.compile("[A-Z][a-z][0-9]_");
    private static final int MAX_USERNAME_LENGTH = 16;
    private static final int MIN_USERNAME_LENGTH = 1;
    private PlayerProfile profile;

    public static Datagram fromBytes(ByteBuf buf) {
        try {
            byte bage = buf.readByte();
            byte bgender = buf.readByte();
            byte bmodel = buf.readByte();
            String u = buf.readCharSequence(buf.capacity() - buf.readerIndex(), Charset.forName("utf-8")).toString().trim();
            String[] s = u.split("@");
            String usernameRaw = s[0];
            String usernameStripped = ALLOWED_USERNAME_CHARACTERS.matcher(s[0]).replaceAll("");
            if (usernameRaw.length() < 1 || usernameRaw.length() > 16 || !usernameRaw.equals(usernameStripped)) {
                GenderForge.log.logWarn("Datagram contained an invalid username format");
                return null;
            }
            String username = usernameStripped;
            username = ALLOWED_USERNAME_CHARACTERS.matcher(username).replaceAll("");
            String uuid = s[1];
            EnumAge age = EnumAge.UNSET.getFromValue(bage);
            EnumGender gender = EnumGender.UNSET.getFromValue(bgender);
            EnumModel model = EnumModel.UNSET.getFromValue(bmodel);
            if (Datagram.notEmpty(username) || Datagram.notEmpty(uuid)) {
                PlayerProfile data = new PlayerProfile(username, uuid);
                data.setAge(age);
                data.setGender(gender);
                data.setModel(model);
                return new Datagram(data);
            }
            GenderForge.log.logWarn("Invalid packet read.");
        }
        catch (Exception e) {
            GenderForge.log.logWarn("Invalid packet read. Error: " + e.getMessage());
        }
        return null;
    }

    private static boolean notEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public static void onMessage(Datagram data, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            NetworkDirection direction = ((NetworkEvent.Context)context.get()).getDirection();
            if (direction.equals((Object)NetworkDirection.PLAY_TO_CLIENT)) {
                Gender.client().tempMgr.getOrCreate(data.profile, true);
            } else if (direction.equals((Object)NetworkDirection.PLAY_TO_SERVER) && ((NetworkEvent.Context)context.get()).getSender() != null) {
                ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
                String senderUUID = sender.m_20149_().toString();
                Component senderUsernameComponent = sender.m_7755_();
                String senderUsername = senderUsernameComponent.getString();
                if (data.profile.name().equals(senderUsername) || data.profile.uuid().toString().equalsIgnoreCase(senderUUID)) {
                    if (Gender.server() == null) {
                        return;
                    }
                    PlayerProfile p = Gender.server().getListManager().getOrCreate(data.profile, true);
                    GenderServer.sendToAllClients(p);
                } else {
                    GenderForge.log.logWarn("Player " + senderUsername + " sent another player's profile to the server. This should never happen! Ignoring datagram.");
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public Datagram(PlayerProfile p) {
        this.profile = p;
    }

    public void toBytes(ByteBuf buf) {
        try {
            String username = this.profile.name();
            String uuid = this.profile.uuid();
            EnumAge age = this.profile.getAge();
            EnumGender gender = this.profile.getGender();
            EnumModel model = this.profile.getModel();
            buf.writeByte(age.ordinal());
            buf.writeByte(gender.ordinal());
            buf.writeByte(model.ordinal());
            buf.writeCharSequence((CharSequence)new StringBuffer(username + "@" + uuid), Charset.forName("utf-8"));
        }
        catch (Exception e) {
            GenderForge.log.logWarn("Failed to convert profile to bytes. Error: " + e.getMessage());
        }
    }
}

