/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.Mod;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import com.github.ipixeli.gender.forge.Datagram;
import com.github.ipixeli.gender.forge.Logger;
import com.github.ipixeli.gender.forge.client.GenderClient;
import com.github.ipixeli.gender.forge.server.GenderServer;
import java.io.File;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.minecraftforge.versions.forge.ForgeVersion;

@net.minecraftforge.fml.common.Mod(value="gender")
public final class GenderForge
implements Mod {
    public static final String VER = "1.9.1";
    public static final String MC = "1.18.1";
    public static final String VERSION = "1.9.1+F4(1.18.1)";
    private static GenderForge instance;
    protected static Logger log;
    private static final String PROTOCOL_VERSION = "1";
    private static final Predicate<String> versions;
    public static final SimpleChannel channel;

    private static File checkSetupDirsAndConfig(File cwd) {
        File modDir = new File(cwd + "/config/gender/");
        if (!modDir.exists()) {
            log.logWarn("Unable to locate missing folder(s): " + modDir.getAbsolutePath());
            if (modDir.mkdirs()) {
                log.logWarn("Successfully created missing folder(s): " + modDir.getAbsolutePath());
            }
        }
        return modDir;
    }

    public static GenderForge get() {
        return instance;
    }

    public GenderForge() {
        instance = this;
        new Gender(this, log);
        log.logInfo("Gender is version 1.9.1+F4(1.18.1) Environment Version is FORGE " + ForgeVersion.getVersion());
        channel.messageBuilder(Datagram.class, 1).decoder(Datagram::fromBytes).encoder(Datagram::toBytes).consumer(Datagram::onMessage).add();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent e) {
        log.logInfo("Client is starting");
        Minecraft mc = Minecraft.m_91087_();
        File modDir = GenderForge.checkSetupDirsAndConfig(mc.f_91069_);
        GenderClient.onStartup(modDir, log, mc);
    }

    @SubscribeEvent
    public void serverSetup(FMLDedicatedServerSetupEvent e) {
        log.logInfo("Server is starting");
        MinecraftServer mcs = ServerLifecycleHooks.getCurrentServer();
        File mcDir = mcs == null ? new File(".") : mcs.m_6237_();
        File modDir = GenderForge.checkSetupDirsAndConfig(mcDir);
        GenderServer.onSetup(modDir, log, mcs);
    }

    @Override
    public void sendProfilePacket(PlayerProfile p) {
        channel.sendToServer((Object)new Datagram(p));
    }

    static {
        log = new Logger();
        versions = v -> PROTOCOL_VERSION.equals(v) || NetworkRegistry.ABSENT.equals(v) || NetworkRegistry.ACCEPTVANILLA.equals(v);
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("gender:gender")).clientAcceptedVersions(versions).serverAcceptedVersions(versions).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

