/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge.client;

import com.github.ipixeli.gender.core.Log;
import com.github.ipixeli.gender.core.client.MCC;
import com.github.ipixeli.gender.core.client.assets.Asset;
import com.github.ipixeli.gender.forge.client.gui.ListScreen;
import com.github.ipixeli.gender.forge.client.gui.ProfileScreen;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public final class Accessor
implements MCC {
    private static Accessor instance;
    private static Minecraft mc;
    private static final Random r;
    private Log log;

    public static Accessor instance() {
        return instance;
    }

    public static Minecraft mc() {
        return Minecraft.m_91087_();
    }

    public Accessor(Minecraft mcIn, Log logIn) {
        instance = this;
        mc = mcIn;
        this.log = logIn;
    }

    @Override
    public void addParticle(double x, double y, double z) {
        double xSpeed = r.nextGaussian() * 0.02;
        double ySpeed = r.nextGaussian() * 0.02;
        double zSpeed = r.nextGaussian() * 0.02;
        Accessor.mc.f_91073_.m_6493_((ParticleOptions)ParticleTypes.f_123750_, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void bindTexture(ResourceLocation res) {
        mc.m_91097_().m_174784_(res);
    }

    @Override
    public void displayScreen(Object screen) {
        mc.m_91346_((Screen)screen);
    }

    public EntityRenderDispatcher getEntityRenderDispatcher() {
        return mc.m_91290_();
    }

    @Override
    public String getMCVer() {
        return mc.m_91388_();
    }

    @Override
    public String getName(Object playerEntity) {
        return ((Player)playerEntity).m_7755_().m_6879_().getString();
    }

    @Override
    public String getNameFromUuid(Object uuidIn) {
        List players = Accessor.mc.f_91073_.m_6907_();
        for (AbstractClientPlayer p : players) {
            if (!p.m_142081_().toString().equals(uuidIn.toString())) continue;
            return this.getName(p);
        }
        return null;
    }

    @Override
    public Object getPlayerByUuid(String uuidStr) {
        UUID uuidObj = UUID.fromString(uuidStr);
        List list = this.getPlayers().stream().filter(e -> e.m_142081_().equals(uuidObj)).collect(Collectors.toList());
        return list.size() > 0 ? list.get(0) : null;
    }

    private List<AbstractClientPlayer> getPlayers() {
        return Accessor.mc.f_91073_.m_6907_();
    }

    public ResourceLocation getResource(String s) {
        return new ResourceLocation(s);
    }

    public LocalPlayer getSelfEntity() {
        return Accessor.mc.f_91074_;
    }

    @Override
    public String getSelfUsername() {
        if (this.getSelfEntity() != null) {
            return this.getName(this.getSelfEntity());
        }
        if (mc.m_91094_() != null) {
            return mc.m_91094_().m_92546_();
        }
        return "whoami";
    }

    @Override
    public String getSelfUuid() {
        if (this.getSelfEntity() != null) {
            return this.getUUID(this.getSelfEntity());
        }
        if (mc.m_91094_() != null) {
            return mc.m_91094_().m_92545_();
        }
        return "whoami";
    }

    @Override
    public String getUUID(Object playerEntity) {
        return ((Player)playerEntity).m_142081_().toString();
    }

    @Override
    public boolean isGuiRender() {
        Screen screen = Accessor.mc.f_91080_;
        return screen instanceof ProfileScreen || screen instanceof ListScreen;
    }

    @Override
    public boolean isIntegratedServer() {
        return mc.m_91091_();
    }

    @Override
    public boolean isSelf(Object player) {
        boolean sameName = this.getSelfUsername().equals(this.getName(player));
        boolean sameID = this.getSelfUuid().equals(this.getUUID(player));
        return sameName && sameID;
    }

    @Override
    public void play(Asset a, float pitch, float x, float y, float z) {
        if (a == null) {
            this.log.logErr("The provided sound asset is null.");
            return;
        }
        ResourceLocation resource = (ResourceLocation)a.get();
        if (resource == null) {
            this.log.logErr("The located resource sound is null.");
            return;
        }
        SoundSource cat = SoundSource.PLAYERS;
        SimpleSoundInstance sound = new SimpleSoundInstance(resource, cat, 1.0f, pitch, false, 0, SoundInstance.Attenuation.NONE, (double)x, (double)y, (double)z, true);
        mc.m_91106_().m_120367_((SoundInstance)sound);
    }

    static {
        r = new Random();
    }
}

