/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge.client;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.client.Logic;
import com.github.ipixeli.gender.core.client.cfg.Config;
import com.github.ipixeli.gender.core.client.events.PlayerHurt;
import com.github.ipixeli.gender.forge.client.Accessor;
import com.github.ipixeli.gender.forge.client.GenderClient;
import com.github.ipixeli.gender.forge.client.LayerPlayer;
import com.github.ipixeli.gender.forge.client.gui.ProfileScreen;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gender", value={Dist.CLIENT})
public final class Events {
    private static boolean needSendPacket = false;

    public Events() {
        Gender.log().logInfo("ClientEvents init");
    }

    @SubscribeEvent
    public static void register(EntityRenderersEvent.AddLayers e) {
        if (!GenderClient.regLayers) {
            GenderClient.regLayers = true;
        }
        Accessor mca = Accessor.instance();
        EntityRenderDispatcher rDispatcher = mca.getEntityRenderDispatcher();
        Map skinMap = rDispatcher.getSkinMap();
        for (Map.Entry entry : skinMap.entrySet()) {
            Gender.log().logInfo("Checking render layer for " + (String)entry.getKey());
            EntityRenderer er = (EntityRenderer)entry.getValue();
            if (!(er instanceof PlayerRenderer)) continue;
            PlayerRenderer renderer = (PlayerRenderer)er;
            renderer.m_115326_((RenderLayer)new LayerPlayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEvent(InputEvent.KeyInputEvent e) {
        if (Minecraft.m_91087_() == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null) {
            return;
        }
        if (e.getAction() == 1 && e.getKey() == GenderClient.key.getKey().m_84873_()) {
            mc.m_91152_((Screen)new ProfileScreen());
        } else if (needSendPacket) {
            Gender.client().onLogin();
            needSendPacket = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEvent(LivingHurtEvent e) {
        if (!Config.playerGenders.getValue().booleanValue() || !Config.playerGenderSounds.getValue().booleanValue()) {
            return;
        }
        if (e.getEntity() == null) {
            return;
        }
        if (!(e.getEntity() instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer p = (AbstractClientPlayer)e.getEntity();
        BlockPos pos = p.m_142538_();
        Accessor mca = Accessor.instance();
        PlayerHurt.event(mca, mca.getUUID(p), mca.getName(p), mca.isSelf(p), pos.m_123341_(), (float)pos.m_123342_() - 0.1f, pos.m_123343_());
        e.setCanceled(true);
    }

    @SubscribeEvent
    public static void onEvent(ClientPlayerNetworkEvent.LoggedInEvent e) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && mc.m_91403_() != null) {
            Gender.client().onLogin();
            needSendPacket = false;
        } else {
            needSendPacket = true;
        }
    }

    @SubscribeEvent
    public static void onEvent(ClientPlayerNetworkEvent.LoggedOutEvent e) {
        Gender.client().onLogout();
    }

    private static TextComponent getCustomNameLabel(Player p, String old) {
        Accessor mca = Accessor.instance();
        String label = Logic.getLabel(mca.getUUID(p), mca.getName(p), mca.isSelf(p), mca.isGuiRender(), old);
        return new TextComponent(label);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEvent(PlayerEvent.NameFormat e) {
        if (e.getEntity() == null || !(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        String strIn = e.getDisplayname().getString();
        TextComponent textOut = Events.getCustomNameLabel(p, strIn);
        e.setDisplayname((Component)textOut);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEvent(RenderNameplateEvent e) {
        if (e.getEntity() == null || !(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        String strIn = e.getContent().getString();
        TextComponent textOut = Events.getCustomNameLabel(p, strIn);
        e.setContent((Component)textOut);
    }
}

