/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge.client;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.client.Logic;
import com.github.ipixeli.gender.core.client.assets.Assets;
import com.github.ipixeli.gender.core.client.assets.Point;
import com.github.ipixeli.gender.core.options.EnumModel;
import com.github.ipixeli.gender.forge.client.Accessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;

public class LayerPlayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private LayerDefinition style1LayerDef = this.initModel("cs1", Assets.model1);
    private LayerDefinition style2LayerDef = this.initModel("cs2", Assets.model2);

    public LayerPlayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> parentIn) {
        super(parentIn);
        Gender.log().logInfo("Finished initilizing Gender layers");
    }

    private LayerDefinition initModel(String n, ArrayList<Point> pts) {
        CubeListBuilder clb = CubeListBuilder.m_171558_();
        for (Point pt : pts) {
            clb.m_171514_(pt.u(), pt.v()).m_171481_(pt.x(), pt.y(), pt.z(), pt.xd(), pt.yd(), pt.zd());
        }
        MeshDefinition md = new MeshDefinition();
        PartDefinition pd = md.m_171576_();
        pd.m_171599_(n, clb, PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)md, (int)64, (int)64);
    }

    public void render(PoseStack pose, MultiBufferSource mbuff, int light, AbstractClientPlayer p, float limbSwing, float limbSwingDif, float tickPartial, float tickAge, float headYaw, float headPitch) {
        if (!p.m_6084_() || p.m_20145_()) {
            return;
        }
        Accessor mca = Accessor.instance();
        EntityRenderDispatcher renderDispatcher = mca.getEntityRenderDispatcher();
        PlayerRenderer renderer = (PlayerRenderer)renderDispatcher.m_114382_((Entity)p);
        RenderType renderType = RenderType.m_110446_((ResourceLocation)renderer.m_5478_(p));
        VertexConsumer consumer = mbuff.m_6299_(renderType);
        int overlay = LivingEntityRenderer.m_115338_((LivingEntity)p, (float)0.0f);
        EnumModel m = Logic.getVisibleModel(mca.getName(p), mca.getUUID(p), mca.isSelf(p), mca.isGuiRender());
        Iterable armors = p.m_6168_();
        for (ItemStack is : armors) {
            if (!(is.m_41720_() instanceof ArmorItem)) continue;
            return;
        }
        ModelPart style1Parts = this.style1LayerDef.m_171564_();
        if (m.ordinal() == EnumModel.CYNTHIA.ordinal()) {
            style1Parts.m_104315_(((PlayerModel)renderer.m_7200_()).f_102810_);
            style1Parts.m_104301_(pose, consumer, light, overlay);
        }
        ModelPart style2Parts = this.style2LayerDef.m_171564_();
        if (m.ordinal() == EnumModel.STEPHANIE.ordinal()) {
            style2Parts.m_104315_(((PlayerModel)renderer.m_7200_()).f_102810_);
            style2Parts.m_104301_(pose, consumer, light, overlay);
        }
    }
}

