/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge.client.gui;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.client.cfg.Config;
import com.github.ipixeli.gender.core.client.cfg.ConfigSetting;
import com.github.ipixeli.gender.core.options.EnumAge;
import com.github.ipixeli.gender.core.options.EnumGender;
import com.github.ipixeli.gender.core.options.EnumModel;
import com.github.ipixeli.gender.core.options.Options;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import com.github.ipixeli.gender.forge.client.Accessor;
import com.github.ipixeli.gender.forge.client.GenderClient;
import com.github.ipixeli.gender.forge.client.gui.BaseScreen;
import com.mojang.blaze3d.vertex.PoseStack;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import net.minecraft.Util;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.versions.forge.ForgeVersion;

public final class InfoScreen
extends BaseScreen {
    private ArrayList<LineData> env = new ArrayList();
    private ArrayList<LineData> player = new ArrayList();
    private ArrayList<LineData> config = new ArrayList();
    private ArrayList<LineData> legend = new ArrayList();
    private ArrayList<LineData> core = new ArrayList();
    private int envWid;
    private int playerWid;
    private int configWid;
    private int legendWid;
    private int coreWid;

    public InfoScreen() {
        super("Client Information");
    }

    private void calculateWidths() {
        Object s = "";
        EnumAge a = EnumAge.UNSET;
        s = (String)s + a.getRenderName() + "; ";
        a = EnumAge.ADULT;
        s = (String)s + a.getRenderName() + "; ";
        a = EnumAge.THREE;
        s = (String)s + a.getRenderName() + " - ";
        a = EnumAge.SEVENTEEN;
        s = (String)s + a.getRenderName() + "; ";
        this.legend.add(new LineData("Ages", (String)s));
        s = "";
        for (EnumGender enumGender : Options.listGenders) {
            s = (String)s + enumGender.getSymbol() + enumGender.getRenderName() + "; ";
        }
        this.legend.add(new LineData("Genders", (String)s));
        s = "";
        for (EnumModel enumModel : Options.listModels) {
            s = (String)s + enumModel.getSymbol() + enumModel.getRenderName() + "; ";
        }
        this.legend.add(new LineData("Models", (String)s));
        s = "";
        for (LineData lineData : this.env) {
            if (lineData.label.length() <= ((String)s).length()) continue;
            s = lineData.label;
        }
        this.envWid = this.f_96547_.m_92895_((String)s + " ");
        s = "";
        for (LineData lineData : this.player) {
            if (lineData.label.length() <= ((String)s).length()) continue;
            s = lineData.label;
        }
        this.playerWid = this.f_96547_.m_92895_((String)s + " ");
        s = "";
        for (LineData lineData : this.config) {
            if (lineData.label.length() <= ((String)s).length()) continue;
            s = lineData.label;
        }
        this.configWid = this.f_96547_.m_92895_((String)s + " ");
        s = "";
        for (LineData lineData : this.legend) {
            if (lineData.label.length() <= ((String)s).length()) continue;
            s = lineData.label;
        }
        this.legendWid = this.f_96547_.m_92895_((String)s + " ");
        for (LineData lineData : this.core) {
            if (lineData.label.length() <= ((String)s).length()) continue;
            s = lineData.label;
        }
        this.coreWid = this.f_96547_.m_92895_((String)s + " ");
        s = "";
    }

    private int drawSection(PoseStack stack, String nameSection, ArrayList<LineData> list, int boundLeft, int boundTop, int boundRight, int x2Offset, int border, int colWidth) {
        int boundBottom = boundTop + border * 2 + list.size() * 10 + 1;
        int y = boundTop + border;
        int x1 = boundLeft + border + 2;
        InfoScreen.m_93172_((PoseStack)stack, (int)(boundLeft + border), (int)(boundTop + border), (int)boundRight, (int)(y + 11), (int)2007682303);
        y = boundTop + border + 2;
        this.f_96547_.m_92883_(stack, nameSection, (float)x1, (float)y, 0xFFFFFF);
        y += 11;
        for (LineData d : list) {
            int c = 0xC7C7C7;
            if (d.value.equals("ENABLED") || d.value.equals("TRUE") || d.value.equals("OK")) {
                c = 0xAAFFAA;
            } else if (d.value.equals("DISABLED") || d.value.equals("FALSE") || d.value.equals("?")) {
                c = 0xFFFFAA;
            }
            if (d.label.length() > 0) {
                this.f_96547_.m_92883_(stack, d.label, (float)x1, (float)y, 0xFFFFFF);
            }
            this.f_96547_.m_92883_(stack, d.value, (float)(boundRight - this.f_96547_.m_92895_(d.value) - 1), (float)y, c);
            y += 9;
        }
        return boundBottom + 6;
    }

    @Override
    public void m_7856_() {
        super.init(this.f_96541_);
        this.env.clear();
        this.player.clear();
        this.config.clear();
        this.legend.clear();
        this.core.clear();
        this.env.add(new LineData("iPixeli's Gender Mod", "1.9.1+F4(1.18.1)"));
        this.env.add(new LineData("Minecraft", Accessor.instance().getMCVer()));
        this.env.add(new LineData("MinecraftForge", ForgeVersion.getVersion()));
        this.env.add(new LineData("Minecraft Environment", Accessor.instance().isIntegratedServer() ? "Integrated" : "Client"));
        this.env.add(new LineData("Profiles", "Client:" + Gender.client().getListManager().getList().size() + "; Temp:" + Gender.client().tempMgr.getList().size()));
        String name = Accessor.instance().getSelfUsername();
        String uuid = Accessor.instance().getSelfUuid();
        String uuidp1 = uuid.toUpperCase().substring(0, uuid.length() / 2);
        String uuidp2 = uuid.toUpperCase().substring(uuid.length() / 2, uuid.length());
        PlayerProfile clientSelf = Gender.client().getListManager().get(name, uuid);
        this.player.add(new LineData("Name", name));
        this.player.add(new LineData("UUID", uuidp1));
        this.player.add(new LineData("", uuidp2));
        this.player.add(new LineData("Client", (String)(clientSelf == null ? "N/A" : clientSelf.getAge().name() + ", " + clientSelf.getGender().name() + ", " + clientSelf.getModel().name())));
        PlayerProfile tempSelf = Gender.client().tempMgr.get(name, uuid);
        this.player.add(new LineData("Temp", (String)(tempSelf == null ? "N/A" : tempSelf.getAge().name() + ", " + tempSelf.getGender().name() + ", " + tempSelf.getModel().name())));
        for (ConfigSetting setting : Config.settings) {
            String k = setting.getName();
            String v = setting.getValueStr();
            if (setting.getName().startsWith("Enable ")) {
                k = setting.getName().replace("Enable ", "");
                v = v.replace("TRUE", "ENABLED");
                v = v.replace("FALSE", "DISABLED");
            }
            this.config.add(new LineData(k, v));
        }
        this.core.add(new LineData("Player Gender Model Layer", GenderClient.regLayers ? "OK" : "?"));
        this.core.add(new LineData("Core Mod: Player Scale", GenderClient.corePlayerScale ? "OK" : "?"));
        this.core.add(new LineData("Core Mod: Player Texture", GenderClient.corePlayerTexture ? "OK" : "?"));
        this.core.add(new LineData("Core Mod: Zombie Texture", GenderClient.coreZombieTexture ? "OK" : "?"));
        this.calculateWidths();
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 149, this.f_96544_ - 57, 298, 20, (Component)new TextComponent("Downloads & Help? -> Click to visit Gender on CurseForge"), onPress -> {
            try {
                Util.m_137581_().m_137650_(new URL("https://www.curseforge.com/minecraft/mc-mods/gender"));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }));
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int mX, int mY, float ticks) {
        this.m_96626_(0);
        super.m_6305_(matrixStack, mX, mY, ticks);
        int border = 1;
        int bottom = this.drawSection(matrixStack, "ENVIRONMENT", this.env, border, 26 + border, this.f_96543_ / 2 - 6 - border / 2, this.envWid + 2, border, this.envWid);
        this.drawSection(matrixStack, "CONFIGURATION", this.config, border, bottom, this.f_96543_ / 2 - 6 - border / 2, this.configWid + 2, border, this.configWid);
        bottom = this.drawSection(matrixStack, "PLAYER INFO", this.player, this.f_96543_ / 2 + border - 6, 26 + border, this.f_96543_ - 2, this.playerWid + 2, border, this.playerWid);
        bottom = this.drawSection(matrixStack, "LEGEND", this.legend, this.f_96543_ / 2 - 6 + border, bottom, this.f_96543_ - border, this.legendWid + border, border, this.legendWid);
        this.drawSection(matrixStack, "MOD STATUS", this.core, this.f_96543_ / 2 - 6 + border, bottom + 2, this.f_96543_ - border, this.coreWid + border, border, this.coreWid);
    }

    private final class LineData {
        public String label;
        public String value;

        private LineData(String l, String v) {
            this.label = l;
            this.value = v;
        }
    }
}

