/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge.server;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.Log;
import com.github.ipixeli.gender.core.profiles.PlayerProfile;
import com.github.ipixeli.gender.forge.Datagram;
import com.github.ipixeli.gender.forge.GenderForge;
import com.github.ipixeli.gender.forge.server.Accessor;
import java.io.File;
import java.util.List;
import net.minecraft.network.Connection;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;

public class GenderServer {
    public static List<String> onCmdList() {
        List<PlayerProfile> profiles = Gender.server().getListManager().getList();
        return Gender.server().onCmdList(profiles);
    }

    public static void onSetup(File modDir, Log log, MinecraftServer server) {
        new Accessor(server);
        Gender.log().logInfo("Setting up Gender server");
        Gender.onServerStartup(modDir);
    }

    public static void sendToAllClients(PlayerProfile p) {
        GenderForge.channel.send(PacketDistributor.ALL.noArg(), (Object)new Datagram(p));
    }

    public static void sendToClient(PlayerProfile p, Connection n) {
        GenderForge.channel.sendTo((Object)new Datagram(p), n, NetworkDirection.PLAY_TO_CLIENT);
    }
}

