/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.core.client.cfg;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.client.cfg.ConfigSetting;
import com.github.ipixeli.gender.core.options.EnumAge;
import com.github.ipixeli.gender.core.options.EnumGender;
import com.github.ipixeli.gender.core.options.EnumModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public final class Config {
    public static final ConfigSetting<String, EnumAge> defaultPlayerAge = new ConfigSetting<String, EnumAge>("Default Player Age", EnumAge.ADULT);
    public static final ConfigSetting<String, EnumModel> defaultPlayerFemaleModel = new ConfigSetting<String, EnumModel>("Default Player Female Model", EnumModel.STEPHANIE);
    public static final ConfigSetting<String, EnumGender> defaultPlayerGender = new ConfigSetting<String, EnumGender>("Default Player Gender", EnumGender.CUSTOM);
    protected static Config instance;
    public static final ConfigSetting<String, Boolean> playerAges;
    public static final ConfigSetting<String, Boolean> playerGenders;
    public static final ConfigSetting<String, Boolean> playerGenderSounds;
    public static final ConfigSetting<String, Boolean> playerUsernameEffect;
    public static final ConfigSetting<String, Boolean> serverPriority;
    public static final ConfigSetting<String, Boolean> zombieGenders;
    public static final ConfigSetting[] settings;
    private static File suchFile;

    public static void defaults() {
        Config.serverPriority.value = true;
        Config.playerAges.value = true;
        Config.playerGenders.value = true;
        Config.playerGenderSounds.value = true;
        Config.playerUsernameEffect.value = true;
        Config.defaultPlayerAge.value = EnumAge.ADULT;
        Config.defaultPlayerGender.value = EnumGender.CUSTOM;
        Config.defaultPlayerFemaleModel.value = EnumModel.STEPHANIE;
        Config.zombieGenders.value = true;
    }

    public static Config instance() {
        return instance;
    }

    private static void save() {
        try {
            PrintWriter writer = new PrintWriter((Writer)new FileWriter(suchFile), false);
            for (ConfigSetting opt : settings) {
                writer.println(opt.name + "=" + opt.value.toString());
            }
            writer.close();
        }
        catch (Exception e) {
            Gender.log().logErr("Failed to save modification settings: " + e);
        }
    }

    public static void toggle(ConfigSetting opt) {
        if (opt.value instanceof EnumAge) {
            EnumAge old = (EnumAge)opt.value;
            EnumAge result = old.next(true);
            opt.value = result;
        } else if (opt.value instanceof EnumGender) {
            EnumGender old = (EnumGender)opt.value;
            EnumGender result = old.next(true);
            opt.value = result;
        } else if (opt.value instanceof EnumModel) {
            EnumModel old = (EnumModel)opt.value;
            EnumModel result = old.next(true);
            opt.value = result;
        } else if (opt.value instanceof Boolean) {
            boolean old = (Boolean)opt.value;
            boolean result = !old;
            opt.value = result;
        } else {
            Gender.log().logWarn("Tried to toggle setting: " + opt.name);
        }
        Config.updateConfig();
    }

    public static void updateConfig() {
        Config.save();
    }

    public Config(File veryDir) {
        instance = this;
        suchFile = new File(veryDir, "client.cfg");
        if (!suchFile.exists()) {
            try {
                suchFile.createNewFile();
                Gender.log().logInfo("Config file is at " + suchFile.getAbsolutePath());
            }
            catch (IOException e) {
                Gender.log().logWarn("Failed to create or locate file " + suchFile.getName() + " with error: " + e.getMessage());
            }
        }
        this.read();
        Config.save();
    }

    private void read() {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(suchFile));
            String s = "";
            while ((s = reader.readLine()) != null) {
                String[] t = s.split("=");
                for (ConfigSetting opt : settings) {
                    if (!t[0].equalsIgnoreCase((String)opt.name)) continue;
                    if (opt.getValue() instanceof Boolean) {
                        boolean v = Boolean.parseBoolean(t[1]);
                        opt.value = v;
                        continue;
                    }
                    if (opt.getValue() instanceof EnumAge) {
                        EnumAge v = EnumAge.valueOf(t[1]);
                        opt.value = v;
                        continue;
                    }
                    if (opt.getValue() instanceof EnumGender) {
                        EnumGender v = EnumGender.valueOf(t[1]);
                        opt.value = v;
                        continue;
                    }
                    if (!(opt.getValue() instanceof EnumModel)) continue;
                    EnumModel v = EnumModel.valueOf(t[1]);
                    opt.value = v;
                }
            }
            reader.close();
        }
        catch (Exception e) {
            Gender.log().logErr("Failed to load modification settings: " + e);
            Config.save();
        }
    }

    static {
        playerAges = new ConfigSetting<String, Boolean>("Enable Player Ages", true);
        playerGenders = new ConfigSetting<String, Boolean>("Enable Player Genders", true);
        playerGenderSounds = new ConfigSetting<String, Boolean>("Enable Player Sounds", true);
        playerUsernameEffect = new ConfigSetting<String, Boolean>("Enable Name Effect", true);
        serverPriority = new ConfigSetting<String, Boolean>("Enable Server Priority", true);
        zombieGenders = new ConfigSetting<String, Boolean>("Enable Zombie Genders", true);
        settings = new ConfigSetting[]{serverPriority, playerAges, playerGenders, playerGenderSounds, playerUsernameEffect, defaultPlayerAge, defaultPlayerGender, defaultPlayerFemaleModel, zombieGenders};
    }
}

