/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.core.options;

import com.github.ipixeli.gender.core.options.Option;
import com.github.ipixeli.gender.core.options.Options;

public enum EnumGender implements Option
{
    UNSET("\u2205", "Unset", "\u00a7f", "\u00a7f"),
    MALE("\u2642", "Male", "\u00a73", "\u00a7b"),
    FEMALE("\u2640", "Female", "\u00a75", "\u00a7d"),
    CUSTOM("", "Custom", "\u00a7f", "\u00a7f");

    public String symbol;
    public String colorA;
    public String colorC;
    private String renderName;

    private EnumGender(String c, String r, String cA, String cC) {
        this.symbol = c;
        this.renderName = r;
        this.colorA = cA;
        this.colorC = cC;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public String getLabelA() {
        return this.colorA + this.symbol + "\u00a7r";
    }

    public String getLabelC() {
        return this.colorC + this.symbol + "\u00a7r";
    }

    @Override
    public String getRenderName() {
        return this.renderName;
    }

    public EnumGender getFromValue(Byte byte1) {
        return Options.listGenders.size() > 0 ? Options.listGenders.stream().filter(opt -> opt.ordinal() == byte1.byteValue()).findFirst().get() : Options.listGenders.get(0);
    }

    public EnumGender next(boolean skip) {
        EnumGender r = UNSET;
        int qty = Options.listGenders.size() - 1;
        if (this.ordinal() < qty) {
            r = Options.listGenders.get(this.ordinal() + 1);
        }
        if (skip && r.equals(UNSET)) {
            r = Options.listGenders.get(1);
        }
        return r;
    }
}

