/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.core.profiles;

import com.github.ipixeli.gender.core.options.EnumAge;
import com.github.ipixeli.gender.core.options.EnumGender;
import com.github.ipixeli.gender.core.options.EnumModel;
import java.util.List;

public final class PlayerProfile {
    private EnumAge age = EnumAge.UNSET;
    private EnumGender gender = EnumGender.UNSET;
    private EnumModel model = EnumModel.UNSET;
    private String name = "";
    private String uuid = "";

    public PlayerProfile(String n, String u) {
        this.name = n;
        this.uuid = u;
    }

    public PlayerProfile(String n, String u, EnumAge a, EnumGender g, EnumModel m) {
        this.name = n;
        this.uuid = u;
        this.age = a;
        this.gender = g;
        this.model = m;
    }

    public EnumAge getAge() {
        return this.age;
    }

    public EnumGender getGender() {
        return this.gender;
    }

    public EnumModel getModel() {
        return this.model;
    }

    private boolean isModelAllowed() {
        boolean resultAge = this.age.lifeStage.id >= this.model.getMinimumRequiredStage().id;
        boolean resultGender = false;
        if (this.model.getAllowedGenders() != null) {
            List<EnumGender> list = this.model.getAllowedGenders();
            resultGender = list.contains(this.gender);
        }
        return resultAge && resultGender;
    }

    public boolean isSamePlayer(PlayerProfile p2) {
        boolean matchesName = this.name().equals(p2.name());
        boolean matchesUUID = this.uuid().equals(p2.uuid());
        return matchesName && matchesUUID;
    }

    public String name() {
        return this.name;
    }

    private EnumModel selectNextAllowedModel() {
        EnumModel[] enumModelArray = EnumModel.values();
        int n = enumModelArray.length;
        for (int i = 0; i < n; ++i) {
            EnumModel m;
            this.model = m = enumModelArray[i];
            if (!this.isModelAllowed()) continue;
            return this.model;
        }
        return EnumModel.UNSET;
    }

    public void setAge(EnumAge v) {
        if (this.age == v) {
            return;
        }
        this.age = v;
        if (!this.isModelAllowed()) {
            this.selectNextAllowedModel();
        }
    }

    public void setGender(EnumGender v) {
        if (this.gender == v) {
            return;
        }
        this.gender = v;
        if (!this.isModelAllowed()) {
            this.selectNextAllowedModel();
        }
    }

    public void setModel(EnumModel v) {
        if (this.model == v) {
            return;
        }
        this.model = v;
        if (!this.isModelAllowed()) {
            this.selectNextAllowedModel();
        }
    }

    public void setUsername(String s) {
        this.name = s;
    }

    public void setUUID(String s) {
        this.uuid = s;
    }

    public String uuid() {
        return this.uuid;
    }
}

