/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge.client;

import com.github.ipixeli.gender.core.Log;
import com.github.ipixeli.gender.core.client.MCC;
import com.github.ipixeli.gender.core.client.assets.Asset;
import com.github.ipixeli.gender.forge.client.gui.ListScreen;
import com.github.ipixeli.gender.forge.client.gui.ProfileScreen;
import com.google.common.collect.Iterators;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public final class Accessor
implements MCC {
    private static Accessor instance;
    private static Minecraft mc;
    private static final Random r;
    private Log log;

    public static Accessor instance() {
        return instance;
    }

    public Accessor(Minecraft mcIn, Log logIn) {
        instance = this;
        mc = mcIn;
        this.log = logIn;
    }

    private List<AbstractClientPlayer> getPlayers() {
        return Accessor.mc.f_91073_.m_6907_();
    }

    @Override
    public void addParticle(double x, double y, double z) {
        double xS = r.nextGaussian() * 0.02;
        double yS = r.nextGaussian() * 0.02;
        double zS = r.nextGaussian() * 0.02;
        Accessor.mc.f_91073_.m_6493_((ParticleOptions)ParticleTypes.f_123750_, true, x, y, z, xS, yS, zS);
    }

    @Override
    public String getName(Object playerEntity) {
        return ((Player)playerEntity).m_7755_().m_6879_().getString();
    }

    @Override
    public Object getPlayerByUuid(String uuidStr) {
        for (Player player : this.getPlayers()) {
            if (!player.m_142081_().toString().equals(uuidStr)) continue;
            return player;
        }
        return null;
    }

    public ResourceLocation getResource(String s) {
        return new ResourceLocation(s);
    }

    @Override
    public String getSelfUsername() {
        if (this.getSelfEntity() != null) {
            return this.getName(this.getSelfEntity());
        }
        if (mc.m_91094_() != null) {
            this.log.logDebug("mc.player is null. Using session profile instead..");
            return mc.m_91094_().m_92546_();
        }
        this.log.logWarn("Couldn't get client player. Did Minecraft start improperly?");
        return "a";
    }

    @Override
    public String getSelfUuid() {
        if (this.getSelfEntity() != null) {
            return this.getUUID(this.getSelfEntity());
        }
        if (mc.m_91094_() != null) {
            return mc.m_91094_().m_92545_();
        }
        return "a";
    }

    @Override
    public boolean isSelf(Object player) {
        boolean sameName = this.getSelfUsername().equals(this.getName(player));
        boolean sameID = this.getSelfUuid().equals(this.getUUID(player));
        return sameName && sameID;
    }

    @Override
    public boolean isGuiRender() {
        Screen screen = Accessor.mc.f_91080_;
        return screen instanceof ProfileScreen || screen instanceof ListScreen;
    }

    @Override
    public void play(Asset a, float pitch, float x, float y, float z) {
        if (a == null) {
            this.log.logErr("The sound asset is null.");
            return;
        }
        ResourceLocation resource = (ResourceLocation)a.get();
        if (resource == null) {
            this.log.logErr("The resource sound is null.");
            return;
        }
        SoundSource cat = SoundSource.PLAYERS;
        SimpleSoundInstance sound = new SimpleSoundInstance(resource, cat, 1.0f, pitch, false, 0, SoundInstance.Attenuation.NONE, (double)x, (double)y, (double)z, true);
        mc.m_91106_().m_120367_((SoundInstance)sound);
    }

    public Player getSelfEntity() {
        return Accessor.mc.f_91074_;
    }

    public String getUUID(Object playerEntity) {
        return ((Player)playerEntity).m_142081_().toString();
    }

    public EntityRenderDispatcher getEntityRenderDispatcher() {
        return mc.m_91290_();
    }

    public void displayScreen(Object screen) {
        mc.m_91346_((Screen)screen);
    }

    public void bindTexture(ResourceLocation res) {
        mc.m_91097_().m_174784_(res);
    }

    public String getMCVer() {
        return mc.m_91388_();
    }

    public boolean isIntegratedServer() {
        return mc.m_91091_();
    }

    public String getNameFromUuid(Object uuidIn) {
        List<AbstractClientPlayer> players = this.getPlayers();
        for (Player player : players) {
            if (!player.m_142081_().toString().equals(uuidIn.toString())) continue;
            return this.getName(player);
        }
        return null;
    }

    public static boolean isWearingTop(AbstractClientPlayer p) {
        Iterable slots = p.m_6168_();
        ItemStack top = (ItemStack)Iterators.get(slots.iterator(), (int)2);
        return top.m_41720_() != Items.f_41852_;
    }

    static {
        r = new Random();
    }
}

