/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.forge.client;

import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.client.Logic;
import com.github.ipixeli.gender.core.client.cfg.Config;
import com.github.ipixeli.gender.core.client.events.PlayerHurt;
import com.github.ipixeli.gender.forge.client.Accessor;
import com.github.ipixeli.gender.forge.client.GenderClient;
import com.github.ipixeli.gender.forge.client.LayerPlayer;
import com.github.ipixeli.gender.forge.client.gui.ProfileScreen;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gender", value={Dist.CLIENT})
public class EventsC {
    public EventsC() {
        Gender.log().logInfo("ClientEvents init");
    }

    @SubscribeEvent
    public static void register(EntityRenderersEvent.AddLayers e) {
        if (!GenderClient.regLayers) {
            GenderClient.regLayers = true;
        }
        EntityRenderDispatcher disp = Accessor.instance().getEntityRenderDispatcher();
        for (Map.Entry entry : disp.getSkinMap().entrySet()) {
            Gender.log().logInfo("Checking render layer for " + (String)entry.getKey());
            EntityRenderer er = (EntityRenderer)entry.getValue();
            if (!(er instanceof PlayerRenderer)) continue;
            PlayerRenderer renderer = (PlayerRenderer)er;
            renderer.m_115326_((RenderLayer)new LayerPlayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderer));
        }
    }

    @SubscribeEvent
    public static void onEvent(InputEvent.KeyInputEvent e) {
        if (e.getAction() != 0 || Minecraft.m_91087_() == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null) {
            return;
        }
        if (e.getKey() == GenderClient.key.getKey().m_84873_()) {
            Accessor.instance().displayScreen((Object)new ProfileScreen());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEvent(LivingHurtEvent e) {
        if (e.getEntity() == null) {
            return;
        }
        if (!(e.getEntity() instanceof Player) || e.getEntity() instanceof AbstractClientPlayer) {
            return;
        }
        if (!Config.playerGenders.getValue().booleanValue() || !Config.playerGenderSounds.getValue().booleanValue()) {
            return;
        }
        Player p = (Player)e.getEntity();
        BlockPos pos = p.m_142538_();
        Accessor mca = Accessor.instance();
        PlayerHurt.event(mca, mca.getUUID(p), mca.getName(p), mca.isSelf(p), pos.m_123341_(), (float)pos.m_123342_() - 0.1f, pos.m_123343_());
    }

    @SubscribeEvent
    public static void onEvent(ClientPlayerNetworkEvent.LoggedInEvent e) {
        if (e.getConnection() == null || e.getConnection().m_129538_() == null) {
            return;
        }
        Gender.client().onLogin();
    }

    @SubscribeEvent
    public static void onEvent(ClientPlayerNetworkEvent.LoggedOutEvent e) {
        Gender.client().onLogout();
    }

    private static TextComponent getCustomNameLabel(Player p, String old) {
        Accessor mca = Accessor.instance();
        String label = Logic.getLabel(mca.getUUID(p), mca.getName(p), mca.isSelf(p), mca.isGuiRender(), old);
        return new TextComponent(label);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEvent(PlayerEvent.NameFormat e) {
        if (e.getEntity() == null || !(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        String s = e.getDisplayname().getString();
        e.setDisplayname((Component)EventsC.getCustomNameLabel(p, s));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEvent(RenderNameplateEvent e) {
        if (e.getEntity() == null || !(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        String s = e.getContent().getString();
        e.setContent((Component)EventsC.getCustomNameLabel(p, s));
    }
}

