/*
 * Decompiled with CFR 0.152.
 */
package net.iPixeli.Gender.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import net.iPixeli.Gender.common.PlayerInfo;

public abstract class FlatList {
    private File suchFile;

    public FlatList(File veryDir, String suchName) {
        this.suchFile = new File(veryDir, suchName);
        if (!this.suchFile.exists()) {
            try {
                this.suchFile.createNewFile();
            }
            catch (IOException e) {
                System.out.println("[Gender] Failed to create or locate file " + suchName + " with error: " + e.getMessage());
            }
        }
    }

    public void readList() {
        try {
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.suchFile));
            String s = "";
            while ((s = bufferedreader.readLine()) != null) {
                if (s == "") continue;
                this.doReadEachLine(s);
            }
            bufferedreader.close();
        }
        catch (Exception e) {
            System.out.println("[Gender] Failed to load flat-list" + this.suchFile.getName() + "with error: " + e.getMessage() + " Recreating...");
            e.printStackTrace();
        }
    }

    public void saveList() {
        try {
            PrintWriter printwriter = new PrintWriter((Writer)new FileWriter(this.suchFile), false);
            this.doWriteLines(printwriter);
            printwriter.close();
        }
        catch (Exception e) {
            System.out.println("[Gender] Failed to save flat-list" + this.suchFile.getName() + "with error: " + e.getMessage() + " Recreating...");
        }
    }

    protected abstract void doReadEachLine(String var1);

    protected abstract void doWriteLines(PrintWriter var1);

    public void writeListToFile(PrintWriter printwriter, List<PlayerInfo> list) {
        for (PlayerInfo p : list) {
            String s = p.getName() + ":" + (p.isFemale() ? "f:" : "m:") + (p.isChild() ? "c:" : "a:") + p.getModel();
            printwriter.println(s);
        }
    }
}

