/*
 * Decompiled with CFR 0.152.
 */
package net.iPixeli.Gender.util;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.iPixeli.Gender.client.ManagerInfoTemp;
import net.iPixeli.Gender.common.Gender;
import net.iPixeli.Gender.common.ManagerInfoServer;
import net.iPixeli.Gender.common.PlayerInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;

public class PacketHandler {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        ByteBuf payload = event.packet.payload();
        String username = new String(payload.readBytes(payload.readInt()).array());
        boolean gender = payload.readBoolean();
        boolean age = payload.readBoolean();
        byte model = payload.readByte();
        if (Gender.instance.config.enableDebugMode) {
            System.out.println("[Gender] [SERVER] username: " + username + ", gender: " + gender + ", age: " + age + ", model: " + model);
        }
        PacketHandler.sendFromServerBroadcastOne(ManagerInfoServer.instance.add(username, gender, age, model, true));
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        ByteBuf payload = event.packet.payload();
        String username = new String(payload.readBytes(payload.readInt()).array());
        boolean gender = payload.readBoolean();
        boolean age = payload.readBoolean();
        byte model = payload.readByte();
        if (Gender.instance.config.enableDebugMode) {
            System.out.println("[Gender] [CLIENT] username: " + username + ", gender: " + gender + ", age: " + age + ", model: " + model);
        }
        ManagerInfoTemp.instance.add(username, gender, age, model, true);
    }

    public static void sendFromServerBroadcastEverything() {
        ArrayList<PlayerInfo> players = ManagerInfoServer.instance.getList();
        for (PlayerInfo i : players) {
            Gender.packetHandler.sendToAll(new FMLProxyPacket(PacketHandler.prepareServerPacket(i), "gender"));
        }
    }

    public static void sendFromServerBroadcastOne(PlayerInfo i) {
        Gender.packetHandler.sendToAll(new FMLProxyPacket(PacketHandler.prepareServerPacket(i), "gender"));
    }

    public static void sendFromServerToPlayer(EntityPlayerMP player) {
        ArrayList<PlayerInfo> players = ManagerInfoServer.instance.getList();
        List<String> onlinePlayers = Arrays.asList(MinecraftServer.func_71276_C().func_71203_ab().func_72369_d());
        for (PlayerInfo i : players) {
            if (!onlinePlayers.contains(i.getName())) continue;
            Gender.packetHandler.sendTo(new FMLProxyPacket(PacketHandler.prepareServerPacket(i), "gender"), player);
        }
    }

    private static ByteBuf prepareServerPacket(PlayerInfo i) {
        ByteBuf buf = Unpooled.buffer();
        String username = i.getName();
        boolean gender = i.isFemale();
        boolean age = i.isChild();
        byte model = i.getModel();
        buf.writeInt(username.getBytes().length);
        buf.writeBytes(username.getBytes());
        buf.writeBoolean(gender);
        buf.writeBoolean(age);
        buf.writeByte((int)model);
        return buf;
    }

    public static void sendClientPlayerInfo(boolean g, boolean a, byte m) {
        String username = Minecraft.func_71410_x().func_110432_I().func_111285_a();
        ByteBuf buf = Unpooled.buffer();
        buf.writeInt(username.getBytes().length);
        buf.writeBytes(username.getBytes());
        buf.writeBoolean(g);
        buf.writeBoolean(a);
        buf.writeByte((int)m);
        Gender.packetHandler.sendToServer(new FMLProxyPacket(buf, "gender"));
    }
}

