/*
 * Decompiled with CFR 0.152.
 */
package mrnerdy42.keywizard.gui;

import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mrnerdy42.keywizard.gui.FreeFormListWidget;
import mrnerdy42.keywizard.gui.KeyWizardScreen;
import mrnerdy42.keywizard.mixin.KeyBindingAccessor;
import mrnerdy42.keywizard.util.KeyBindingUtil;
import net.minecraft.class_1074;
import net.minecraft.class_3000;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_350;
import net.minecraft.class_3675;
import org.jetbrains.annotations.Nullable;

public class KeyBindingListWidget
extends FreeFormListWidget<BindingEntry>
implements class_3000 {
    public KeyWizardScreen keyWizardScreen;
    private String currentFilterText = "";
    private String currentCategory = "key.categories.keywizard.all";

    public KeyBindingListWidget(KeyWizardScreen keyWizardScreen, int top, int left, int width, int height, int itemHeight) {
        super(class_310.method_1551(), top, left, width, height, itemHeight);
        this.keyWizardScreen = keyWizardScreen;
        for (class_304 k : this.minecraft.field_1690.field_1839) {
            this.addEntry(new BindingEntry(k));
        }
        this.setSelected((class_350.class_351)this.children().get(0));
    }

    @Nullable
    public class_304 getSelectedKeyBinding() {
        if (this.getSelected() == null) {
            return null;
        }
        return ((BindingEntry)this.getSelected()).keyBinding;
    }

    private void updateList() {
        boolean categoryUpdate;
        boolean filterUpdate = !this.currentFilterText.equals(this.keyWizardScreen.getFilterText());
        boolean bl = categoryUpdate = !this.currentCategory.equals(this.keyWizardScreen.getSelectedCategory());
        if (categoryUpdate || filterUpdate) {
            if (categoryUpdate) {
                this.currentCategory = this.keyWizardScreen.getSelectedCategory();
            }
            class_304[] bindings = this.getBindingsByCategory(this.currentCategory);
            if (filterUpdate) {
                this.currentFilterText = this.keyWizardScreen.getFilterText();
                if (!this.currentFilterText.equals("")) {
                    bindings = this.filterBindings(bindings, this.currentFilterText);
                }
            }
            this.children().clear();
            if (bindings.length > 0) {
                for (class_304 k : bindings) {
                    this.addEntry(new BindingEntry(k));
                }
                this.setSelected((class_350.class_351)this.children().get(0));
            } else {
                this.setSelected(null);
            }
            this.setScrollAmount(0.0);
        }
    }

    private class_304[] filterBindings(class_304[] bindings, String filterText) {
        class_304[] bindingsFiltered = bindings;
        String keyNameRegex = "<.*>";
        Matcher keyNameMatcher = Pattern.compile(keyNameRegex).matcher(filterText);
        if (keyNameMatcher.find()) {
            String keyNameWithBrackets = keyNameMatcher.group();
            String keyName = keyNameWithBrackets.replace("<", "").replace(">", "");
            filterText = filterText.replace(keyNameWithBrackets, "");
            bindingsFiltered = this.filterBindingsByKey(bindingsFiltered, keyName);
        }
        if (!filterText.equals("")) {
            bindingsFiltered = this.filterBindingsByName(bindingsFiltered, filterText);
        }
        return bindingsFiltered;
    }

    private class_304[] filterBindingsByName(class_304[] bindings, String bindingName) {
        String[] words = bindingName.split("\\s+");
        class_304[] bindingsFiltered = (class_304[])Arrays.stream(bindings).filter(binding -> {
            boolean flag = true;
            for (String w : words) {
                flag = flag && class_1074.method_4662((String)binding.method_1431(), (Object[])new Object[0]).toLowerCase().contains(w.toLowerCase());
            }
            return flag;
        }).toArray(class_304[]::new);
        return bindingsFiltered;
    }

    private class_304[] filterBindingsByKey(class_304[] bindings, String keyName) {
        return (class_304[])Arrays.stream(bindings).filter(b -> {
            String otherKeyName = class_1074.method_4663((String)((KeyBindingAccessor)b).getKeyCode().method_1441()) ? class_1074.method_4662((String)((KeyBindingAccessor)b).getKeyCode().method_1441(), (Object[])new Object[0]) : class_3675.method_15988((int)((KeyBindingAccessor)b).getKeyCode().method_1444());
            return class_1074.method_4662((String)otherKeyName, (Object[])new Object[0]).toLowerCase().equals(keyName.toLowerCase());
        }).toArray(class_304[]::new);
    }

    private class_304[] getBindingsByCategory(String category) {
        class_304[] bindings = Arrays.copyOf(this.minecraft.field_1690.field_1839, this.minecraft.field_1690.field_1839.length);
        switch (category) {
            case "key.categories.keywizard.all": {
                return bindings;
            }
            case "key.categories.keywizard.conflicts": {
                Map<class_3675.class_306, Integer> bindingCounts = KeyBindingUtil.getBindingCountsByKey();
                return (class_304[])Arrays.stream(bindings).filter(b -> (Integer)bindingCounts.get(((KeyBindingAccessor)b).getKeyCode()) > 1 && ((KeyBindingAccessor)b).getKeyCode().method_1444() != -1).toArray(class_304[]::new);
            }
            case "key.categories.keywizard.unbound": {
                return (class_304[])Arrays.stream(bindings).filter(b -> b.method_1415()).toArray(class_304[]::new);
            }
        }
        return (class_304[])Arrays.stream(bindings).filter(b -> b.method_1423() == category).toArray(class_304[]::new);
    }

    public void method_16896() {
        this.updateList();
    }

    public class BindingEntry
    extends FreeFormListWidget.Entry {
        private final class_304 keyBinding;

        public BindingEntry(class_304 keyBinding) {
            this.keyBinding = keyBinding;
        }

        @Override
        public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            ((KeyBindingListWidget)KeyBindingListWidget.this).minecraft.field_1772.method_1720(class_1074.method_4662((String)this.keyBinding.method_1431(), (Object[])new Object[0]), (float)x, (float)y, -1);
            int color = -6710887;
            class_327 class_3272 = ((KeyBindingListWidget)KeyBindingListWidget.this).minecraft.field_1772;
            String string = this.keyBinding.method_16007();
            float f = x;
            ((KeyBindingListWidget)KeyBindingListWidget.this).minecraft.field_1772.getClass();
            class_3272.method_1720(string, f, (float)(y + 9 + 5), color);
        }
    }
}

