/*
 * Decompiled with CFR 0.152.
 */
package mrnerdy42.keywizard.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import mrnerdy42.keywizard.gui.KeyWizardScreen;
import mrnerdy42.keywizard.mixin.KeyBindingAccessor;
import mrnerdy42.keywizard.util.DrawingUtil;
import net.minecraft.class_1074;
import net.minecraft.class_3000;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_362;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4264;
import net.minecraft.class_437;

public class KeyboardWidget
extends class_362
implements class_4068,
class_3000 {
    public KeyWizardScreen keyWizardScreen;
    private HashMap<Integer, KeyboardKeyWidget> keys = new HashMap();
    private float anchorX;
    private float anchorY;

    protected KeyboardWidget(KeyWizardScreen keyWizardScreen, float anchorX, float anchorY) {
        this.keyWizardScreen = keyWizardScreen;
        this.anchorX = anchorX;
        this.anchorY = anchorY;
    }

    public float addKey(float relativeX, float relativeY, float width, float height, float keySpacing, int keyCode) {
        this.keys.put(keyCode, new KeyboardKeyWidget(keyCode, this.anchorX + relativeX, this.anchorY + relativeY, width, height, class_3675.class_307.field_1668));
        return relativeX + width + keySpacing;
    }

    public float addKey(float relativeX, float relativeY, float width, float height, float keySpacing, int keyCode, class_3675.class_307 keyType) {
        this.keys.put(keyCode, new KeyboardKeyWidget(keyCode, this.anchorX + relativeX, this.anchorY + relativeY, width, height, keyType));
        return relativeX + width + keySpacing;
    }

    public void render(int mouseX, int mouseY, float delta) {
        List<? extends KeyboardKeyWidget> keys = this.children();
        for (KeyboardKeyWidget keyboardKeyWidget : keys) {
            keyboardKeyWidget.render(mouseX, mouseY, delta);
        }
        if (!this.keyWizardScreen.getCategorySelectorExtended()) {
            for (KeyboardKeyWidget keyboardKeyWidget : keys) {
                if (!keyboardKeyWidget.active || !keyboardKeyWidget.isHovered()) continue;
                this.keyWizardScreen.renderTooltip(keyboardKeyWidget.tooltipText, mouseX, mouseY);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.keyWizardScreen.getCategorySelectorExtended()) {
            for (KeyboardKeyWidget keyboardKeyWidget : this.children()) {
                if (!keyboardKeyWidget.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    public List<? extends KeyboardKeyWidget> children() {
        return new ArrayList<KeyboardKeyWidget>(this.keys.values());
    }

    public void method_16896() {
        for (KeyboardKeyWidget keyboardKeyWidget : this.children()) {
            keyboardKeyWidget.method_16896();
        }
    }

    public float getAnchorX() {
        return this.anchorX;
    }

    public float getAnchorY() {
        return this.anchorY;
    }

    public class KeyboardKeyWidget
    extends class_4264
    implements class_3000 {
        public float x;
        public float y;
        protected float width;
        protected float height;
        private class_3675.class_306 key;
        private List<String> tooltipText;

        protected KeyboardKeyWidget(int keyCode, float x, float y, float width, float height, class_3675.class_307 keyType) {
            super((int)x, (int)y, (int)width, (int)height, "");
            this.tooltipText = new ArrayList<String>();
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.key = keyType.method_1447(keyCode);
            String message = class_1074.method_4663((String)this.key.method_1441()) ? class_1074.method_4662((String)this.key.method_1441(), (Object[])new Object[0]) : class_3675.method_15988((int)this.key.method_1444());
            this.setMessage(message);
        }

        public void renderButton(int mouseX, int mouseY, float delta) {
            int bindingCount = this.tooltipText.size();
            int color = 0;
            if (this.active) {
                if (this.isHovered() && !KeyboardWidget.this.keyWizardScreen.getCategorySelectorExtended()) {
                    color = -5592406;
                    if (bindingCount == 1) {
                        color = -16733696;
                    } else if (bindingCount > 1) {
                        color = -5636096;
                    }
                } else {
                    color = -1;
                    if (bindingCount == 1) {
                        color = -16711936;
                    } else if (bindingCount > 1) {
                        color = -65536;
                    }
                }
            } else {
                color = -11184811;
            }
            DrawingUtil.drawNoFillRect(this.x, this.y, this.x + this.width, this.y + this.height, color);
            class_327 textRenderer = class_310.method_1551().field_1772;
            textRenderer.method_1720(this.getMessage(), this.x + this.width / 2.0f - (float)(textRenderer.method_1727(this.getMessage()) / 2), this.y + (this.height - 6.0f) / 2.0f, color);
        }

        public void onPress() {
            this.playDownSound(class_310.method_1551().method_1483());
            if (class_437.hasShiftDown()) {
                KeyboardWidget.this.keyWizardScreen.setSearchText("<" + this.getMessage() + ">");
            } else {
                class_304 selectedKeyBinding = KeyboardWidget.this.keyWizardScreen.getSelectedKeyBinding();
                if (selectedKeyBinding != null) {
                    selectedKeyBinding.method_1422(this.key);
                    class_304.method_1426();
                }
            }
        }

        private void updateTooltip() {
            ArrayList<String> tooltipText = new ArrayList<String>();
            for (class_304 b : class_310.method_1551().field_1690.field_1839) {
                if (!((KeyBindingAccessor)b).getKeyCode().equals((Object)this.key)) continue;
                tooltipText.add(class_1074.method_4662((String)b.method_1431(), (Object[])new Object[0]));
            }
            this.tooltipText = tooltipText.stream().sorted().collect(Collectors.toCollection(ArrayList::new));
        }

        public void method_16896() {
            this.updateTooltip();
        }
    }
}

