/*
 * Decompiled with CFR 0.152.
 */
package mrnerdy42.keywizard.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mrnerdy42.keywizard.gui.FreeFormListWidget;
import mrnerdy42.keywizard.gui.KeyWizardScreen;
import mrnerdy42.keywizard.mixin.KeyBindingAccessor;
import mrnerdy42.keywizard.util.KeyBindingUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.IScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.Nullable;

public class KeyBindingListWidget
extends FreeFormListWidget<BindingEntry>
implements IScreen {
    public KeyWizardScreen keyWizardScreen;
    private String currentFilterText = "";
    private String currentCategory = "key.categories.keywizard.all";

    public KeyBindingListWidget(KeyWizardScreen keyWizardScreen, int top, int left, int width, int height, int itemHeight) {
        super(Minecraft.func_71410_x(), top, left, width, height, itemHeight);
        this.keyWizardScreen = keyWizardScreen;
        for (KeyBinding k : this.field_230668_b_.field_71474_y.field_74324_K) {
            this.func_230513_b_(new BindingEntry(k));
        }
        this.func_241215_a_((FreeFormListWidget.Entry)((Object)this.func_231039_at__().get(0)));
    }

    @Nullable
    public KeyBinding getSelectedKeyBinding() {
        if (this.func_230958_g_() == null) {
            return null;
        }
        return ((BindingEntry)this.func_230958_g_()).keyBinding;
    }

    private void updateList() {
        boolean categoryUpdate;
        boolean filterUpdate = !this.currentFilterText.equals(this.keyWizardScreen.getFilterText());
        boolean bl = categoryUpdate = !this.currentCategory.equals(this.keyWizardScreen.getSelectedCategory());
        if (categoryUpdate || filterUpdate) {
            if (categoryUpdate) {
                this.currentCategory = this.keyWizardScreen.getSelectedCategory();
            }
            KeyBinding[] bindings = this.getBindingsByCategory(this.currentCategory);
            if (filterUpdate) {
                this.currentFilterText = this.keyWizardScreen.getFilterText();
                if (!this.currentFilterText.equals("")) {
                    bindings = this.filterBindings(bindings, this.currentFilterText);
                }
            }
            this.func_231039_at__().clear();
            if (bindings.length > 0) {
                for (KeyBinding k : bindings) {
                    this.func_230513_b_(new BindingEntry(k));
                }
                this.func_241215_a_((FreeFormListWidget.Entry)((Object)this.func_231039_at__().get(0)));
            } else {
                this.func_241215_a_(null);
            }
            this.func_230932_a_(0.0);
        }
    }

    private KeyBinding[] filterBindings(KeyBinding[] bindings, String filterText) {
        KeyBinding[] bindingsFiltered = bindings;
        String keyNameRegex = "<.*>";
        Matcher keyNameMatcher = Pattern.compile(keyNameRegex).matcher(filterText);
        if (keyNameMatcher.find()) {
            String keyNameWithBrackets = keyNameMatcher.group();
            String keyName = keyNameWithBrackets.replace("<", "").replace(">", "");
            filterText = filterText.replace(keyNameWithBrackets, "");
            bindingsFiltered = this.filterBindingsByKey(bindingsFiltered, keyName);
        }
        if (!filterText.equals("")) {
            bindingsFiltered = this.filterBindingsByName(bindingsFiltered, filterText);
        }
        return bindingsFiltered;
    }

    private KeyBinding[] filterBindingsByName(KeyBinding[] bindings, String bindingName) {
        String[] words = bindingName.split("\\s+");
        KeyBinding[] bindingsFiltered = (KeyBinding[])Arrays.stream(bindings).filter(binding -> {
            boolean flag = true;
            for (String w : words) {
                flag = flag && I18n.func_135052_a((String)binding.func_151464_g(), (Object[])new Object[0]).toLowerCase().contains(w.toLowerCase());
            }
            return flag;
        }).toArray(KeyBinding[]::new);
        return bindingsFiltered;
    }

    private KeyBinding[] filterBindingsByKey(KeyBinding[] bindings, String keyName) {
        return (KeyBinding[])Arrays.stream(bindings).filter(b -> {
            ITextComponent t = b.func_238171_j_();
            if (t instanceof TranslationTextComponent) {
                return I18n.func_135052_a((String)((TranslationTextComponent)t).func_150268_i(), (Object[])new Object[0]).toLowerCase().equals(keyName.toLowerCase());
            }
            return t.func_150261_e().toLowerCase().equals(keyName.toLowerCase());
        }).toArray(KeyBinding[]::new);
    }

    private KeyBinding[] getBindingsByCategory(String category) {
        KeyBinding[] bindings = Arrays.copyOf(this.field_230668_b_.field_71474_y.field_74324_K, this.field_230668_b_.field_71474_y.field_74324_K.length);
        switch (category) {
            case "key.categories.keywizard.all": {
                return bindings;
            }
            case "key.categories.keywizard.conflicts": {
                Map<InputMappings.Input, Integer> bindingCounts = KeyBindingUtil.getBindingCountsByKey();
                return (KeyBinding[])Arrays.stream(bindings).filter(b -> (Integer)bindingCounts.get(((KeyBindingAccessor)b).getBoundKey()) > 1 && ((KeyBindingAccessor)b).getBoundKey().func_197937_c() != -1).toArray(KeyBinding[]::new);
            }
            case "key.categories.keywizard.unbound": {
                return (KeyBinding[])Arrays.stream(bindings).filter(b -> b.func_197986_j()).toArray(KeyBinding[]::new);
            }
        }
        return (KeyBinding[])Arrays.stream(bindings).filter(b -> b.func_151466_e() == category).toArray(KeyBinding[]::new);
    }

    public void func_231023_e_() {
        this.updateList();
    }

    public class BindingEntry
    extends FreeFormListWidget.Entry {
        private final KeyBinding keyBinding;

        public BindingEntry(KeyBinding keyBinding) {
            super(KeyBindingListWidget.this);
            this.keyBinding = keyBinding;
        }

        @Override
        public void func_230432_a_(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            KeyBindingListWidget.this.field_230668_b_.field_71466_p.func_243246_a(matrices, (ITextComponent)new TranslationTextComponent(this.keyBinding.func_151464_g()), (float)x, (float)y, -1);
            int color = -6710887;
            FontRenderer fontRenderer = KeyBindingListWidget.this.field_230668_b_.field_71466_p;
            ITextComponent iTextComponent = this.keyBinding.func_238171_j_();
            float f = x;
            Objects.requireNonNull(KeyBindingListWidget.this.field_230668_b_.field_71466_p);
            fontRenderer.func_243246_a(matrices, iTextComponent, f, (float)(y + 9 + 5), color);
        }
    }
}

